/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.PrefKey;
import com.deltawalker.script.Comparison;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.TimeFormatter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

public final class DiffMethodUtil {
    private static Map<Set<Comparison.Method>, String> method2Text = new HashMap<Set<Comparison.Method>, String>(4);

    public static String format(Set<Comparison.Method> set) {
        String string = method2Text.get(set);
        if (string == null) {
            string = "";
            for (Comparison.Method method : set) {
                string = String.valueOf(string) + method.toDisplayString() + '/';
            }
            if (!StringUtil.isEmpty((String)string)) {
                string = string.substring(0, string.length() - 1);
                method2Text.put(set, string);
            }
        }
        return string;
    }

    public static String formatForToolTip(Set<Comparison.Method> set, Object object) {
        String string = "Different by ";
        for (Comparison.Method method : set) {
            string = method == Comparison.Method.DATE_MODIFIED && object != null ? String.valueOf(string) + method.toToolTipString() + " [" + TimeFormatter.formatDelta((Long)object / 1000L) + "], " : String.valueOf(string) + method.toToolTipString() + ", ";
        }
        if (!StringUtil.isEmpty((String)string)) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static Set<Comparison.Method> fromInt(int n) {
        EnumSet<Comparison.Method> enumSet = EnumSet.noneOf(Comparison.Method.class);
        Comparison.Method[] methodArray = Comparison.Method.values();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Comparison.Method method = methodArray[n3];
            if (DiffMethodUtil.isSet(n, method.toInt())) {
                enumSet.add(method);
            }
            ++n3;
        }
        return enumSet;
    }

    public static boolean isContent(Set<Comparison.Method> set) {
        assert (!set.isEmpty());
        return set.contains((Object)Comparison.Method.AS_TEXT) || set.contains((Object)Comparison.Method.BYTE_BY_BYTE);
    }

    public static boolean isQuick(Set<Comparison.Method> set) {
        assert (!set.isEmpty());
        return set.contains((Object)Comparison.Method.ATTRIBUTES) || set.contains((Object)Comparison.Method.DATE_MODIFIED) || set.contains((Object)Comparison.Method.SIZE);
    }

    private static final boolean isSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean isTextCompare(IPreferenceStore iPreferenceStore) {
        Set<Comparison.Method> set = DiffMethodUtil.prune(DiffMethodUtil.fromInt(iPreferenceStore.getInt(PrefKey.D_COMP_METHOD.toString())), iPreferenceStore);
        return set.contains((Object)Comparison.Method.AS_TEXT);
    }

    public static Set<Comparison.Method> prune(Set<Comparison.Method> set, IPreferenceStore iPreferenceStore) {
        EnumSet<Comparison.Method> enumSet = EnumSet.copyOf(set);
        if (iPreferenceStore.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString())) {
            enumSet.remove((Object)Comparison.Method.DATE_MODIFIED);
            enumSet.remove((Object)Comparison.Method.SIZE);
            enumSet.remove((Object)Comparison.Method.ATTRIBUTES);
            if (enumSet.isEmpty()) {
                enumSet.add(Comparison.Method.AS_TEXT);
            }
        } else {
            enumSet.remove((Object)Comparison.Method.BYTE_BY_BYTE);
            enumSet.remove((Object)Comparison.Method.AS_TEXT);
        }
        return enumSet;
    }

    public static int toInt(Set<Comparison.Method> set) {
        int n = 0;
        Comparison.Method[] methodArray = Comparison.Method.values();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Comparison.Method method = methodArray[n3];
            if (set.contains((Object)method)) {
                n |= method.toInt();
            }
            ++n3;
        }
        return n;
    }

    private DiffMethodUtil() {
    }
}

