/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.DocFactory;
import com.deltawalker.DocType;
import com.deltawalker.IPersistable;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.Pre;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.StateBoss;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.interfaces.IDocFactory;
import com.deltawalker.interfaces.IFilterBoss;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.internal.script.HistoryEntry;
import com.deltawalker.internal.ui.DocWorkbenchAdapter;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.sessions.DocBoss;
import com.deltawalker.structure.Sync2WayOp;
import com.deltawalker.text.Filters;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileInfoEx;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.StructFileInfo;
import com.deltopia.io.TextEncoding;
import com.deltopia.io.UriInfoKey;
import com.deltopia.jface.util.ImageDataUtil;
import com.deltopia.jface.util.SelectionDialogUtil;
import com.deltopia.util.ArrayUtil;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffDoc
extends EventManager
implements IDiffDoc,
IEditorInput,
IJsonState {
    private static final IApp app = App.instance();
    private static final Logger LOG = LoggerFactory.getLogger(DiffDoc.class);
    private static final String NAME_SEPARATOR = " <--> ";
    public static final double SAME_TRANSPARENCY = 0.65;
    private boolean beInHistory = true;
    private ContentType cType = ContentType.UNKNOWN;
    private final List<Map<Role, IDoc>> docTriads = new CopyOnWriteArrayList<Map<Role, IDoc>>();
    private final Map<Role, String> extensions = new ConcurrentHashMap<Role, String>(Role.count());
    private boolean favorite = false;
    private UUID filtersId;
    private boolean hasOpenView;
    private com.deltawalker.script.HistoryEntry historyEntry;
    private UUID id = UUID.randomUUID();
    private final Map<Image, Image> img2dimImg = new ConcurrentHashMap<Image, Image>();
    private String jobName;
    private UriInfo mergedUI;
    private final List<IDiffModel> models = new CopyOnWriteArrayList<IDiffModel>();
    private String name = "";
    private IPreferenceStore prefs;
    private Sync2WayOp sync2WayOp = Sync2WayOp.NONE;
    private boolean threeWay;
    private long timeCreated;
    private long timeOpened;
    private final Map<Role, UriInfo> uriInfos = new ConcurrentHashMap<Role, UriInfo>(Role.count());
    private boolean working;

    private static String constrainTitle(String string) {
        int n = Math.round(30.0f);
        return StringUtil.ellipsize((String)string, (int)n, (int)60);
    }

    public static String constructFullTitle(IDiffDoc iDiffDoc, boolean bl) {
        if (!iDiffDoc.getName().isEmpty()) {
            return DiffDoc.constrainTitle(iDiffDoc.getName());
        }
        IDoc iDoc = iDiffDoc.doc(0, Role.REF);
        IDoc iDoc2 = iDiffDoc.doc(0, Role.ONE);
        if (!iDiffDoc.isThreeWay()) {
            String string = bl ? UIMsg.CompositeEditor_title2wayQuotes : UIMsg.CompositeEditor_title2way;
            Object[] objectArray = new String[]{DiffDoc.constrainTitle(iDoc != null ? iDoc.getName() : ""), DiffDoc.constrainTitle(iDoc2 != null ? iDoc2.getName() : "")};
            return NLS.bind((String)string, (Object[])objectArray);
        }
        String string = bl ? UIMsg.CompositeEditor_title3wayQuotes : UIMsg.CompositeEditor_title3way;
        IDoc iDoc3 = iDiffDoc.doc(0, Role.TWO);
        Object[] objectArray = new String[]{DiffDoc.constrainTitle(iDoc2 != null ? iDoc2.getName() : ""), DiffDoc.constrainTitle(iDoc != null ? iDoc.getName() : ""), DiffDoc.constrainTitle(iDoc3 != null ? iDoc3.getName() : "")};
        return NLS.bind((String)string, (Object[])objectArray);
    }

    public static Map<Role, String> getFileExtensions(Map<Role, UriInfo> map) {
        EnumMap<Role, String> enumMap = new EnumMap<Role, String>(Role.class);
        for (Map.Entry<Role, UriInfo> entry : map.entrySet()) {
            String string = FileUtil.getExtension((String)entry.getValue().uri());
            enumMap.put(entry.getKey(), string);
        }
        return enumMap;
    }

    public static String longestSubstring(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            return "";
        }
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int[][] nArray = new int[string.length()][string2.length()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = 0;
            while (n4 < string2.length()) {
                if (string.charAt(n3) == string2.charAt(n4)) {
                    nArray[n3][n4] = n3 == 0 || n4 == 0 ? 1 : 1 + nArray[n3 - 1][n4 - 1];
                    if (nArray[n3][n4] > n) {
                        n = nArray[n3][n4];
                        int n5 = n3 - nArray[n3][n4] + 1;
                        if (n2 == n5) {
                            stringBuilder.append(string.charAt(n3));
                        } else {
                            n2 = n5;
                            stringBuilder = new StringBuilder();
                            stringBuilder.append(string.substring(n2, n3 + 1));
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static StructFileInfo readFileInfo(JsonReader jsonReader, StructFileInfo structFileInfo, Map<Role, StructFileInfo> map, Role[] roleArray) throws IOException {
        StructFileInfo structFileInfo2;
        String string;
        String string2 = null;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        Long l3 = null;
        Long l4 = null;
        Object object = null;
        Object object2 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            string = jsonReader.nextName();
            if (string.equals("rl")) {
                if (roleArray != null) {
                    roleArray[0] = Role.fromInt(jsonReader.nextInt());
                    continue;
                }
                jsonReader.skipValue();
                continue;
            }
            if (string.equals("nm")) {
                string2 = jsonReader.nextString();
                continue;
            }
            if (string.equals("at")) {
                n = jsonReader.nextInt();
                continue;
            }
            if (string.equals("lm")) {
                l2 = jsonReader.nextLong();
                continue;
            }
            if (string.equals("sz")) {
                l = jsonReader.nextLong();
                continue;
            }
            if (string.equals("dt")) {
                l4 = jsonReader.nextLong();
                continue;
            }
            if (string.equals("ou")) {
                structFileInfo2 = jsonReader.peek();
                if (structFileInfo2 == JsonToken.NUMBER) {
                    object = jsonReader.nextInt();
                    continue;
                }
                if (structFileInfo2 == JsonToken.STRING) {
                    object = jsonReader.nextString();
                    continue;
                }
                assert (false);
                continue;
            }
            if (string.equals("og")) {
                structFileInfo2 = jsonReader.peek();
                if (structFileInfo2 == JsonToken.NUMBER) {
                    object2 = jsonReader.nextInt();
                    continue;
                }
                if (structFileInfo2 == JsonToken.STRING) {
                    object2 = jsonReader.nextString();
                    continue;
                }
                assert (false);
                continue;
            }
            if (string.equals("lo")) {
                l3 = jsonReader.nextLong();
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        if (StringUtil.isEmpty(string2)) {
            LOG.error("StructFileInfo without a name?");
            throw new IllegalStateException("StructFileInfo without a name?");
        }
        if (map != null) {
            structFileInfo = map.get((Object)roleArray[0]);
        }
        string = l4 != null || l3 != null || object != null || object2 != null ? new FileInfoEx(string2, n, l, l2, l3.longValue(), l4.longValue(), object, object2) : new FileInfo(string2, n, l, l2);
        structFileInfo2 = new StructFileInfo((FileInfo)string, structFileInfo);
        if (structFileInfo != null) {
            structFileInfo.addChild(structFileInfo2);
        }
        return structFileInfo2;
    }

    private static Map<Role, StructFileInfo> readNode(JsonReader jsonReader, Map<Role, StructFileInfo> map, Set<Role> set) throws IOException {
        Map<Role, StructFileInfo> map2 = null;
        Map<Role, StructFileInfo> map3 = null;
        Map<Role, StructFileInfo> map4 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("nd")) {
                map3 = DiffDoc.readNode(jsonReader, map4, set);
                continue;
            }
            if (string.equals("el")) {
                if (map3 == null) {
                    map3 = new EnumMap<Role, StructFileInfo>(Role.class);
                }
                Role[] roleArray = new Role[1];
                StructFileInfo structFileInfo = DiffDoc.readFileInfo(jsonReader, null, map, roleArray);
                map3.put(roleArray[0], structFileInfo);
                if (map == null) {
                    map2 = map3;
                }
                if (map4 == map3 || !structFileInfo.isDirectory()) continue;
                map4 = map3;
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return map2 != null ? map2 : map3;
    }

    private static StructFileInfo readNode(JsonReader jsonReader, StructFileInfo structFileInfo) throws IOException {
        StructFileInfo structFileInfo2 = null;
        StructFileInfo structFileInfo3 = null;
        StructFileInfo structFileInfo4 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("nd")) {
                structFileInfo3 = DiffDoc.readNode(jsonReader, structFileInfo4);
                continue;
            }
            if (string.equals("el")) {
                structFileInfo3 = DiffDoc.readFileInfo(jsonReader, structFileInfo, null, null);
                if (structFileInfo == null) {
                    structFileInfo2 = structFileInfo3;
                }
                if (!structFileInfo3.isDirectory()) continue;
                structFileInfo4 = structFileInfo3;
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return structFileInfo2 != null ? structFileInfo2 : structFileInfo3;
    }

    public static boolean saveDirtyDocs(AdaptableList adaptableList) {
        if (adaptableList.size() <= 0) {
            return true;
        }
        Shell shell = UIUtil.getActiveWindowShell();
        SelectionDialog selectionDialog = SelectionDialogUtil.createSelectionDialog(shell, adaptableList, (ITreeContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new LabelProvider(), Msg.DiffDoc_savePrompt, Msg.DiffDoc_save, Msg.DiffDoc_dontSave, true);
        selectionDialog.setInitialSelections(adaptableList.getChildren());
        selectionDialog.setTitle(UIMsg.CompareEditorHelper_saveDialogTitle);
        if (selectionDialog.open() == 1) {
            return false;
        }
        Object[] objectArray = selectionDialog.getResult();
        if (objectArray == null || objectArray.length <= 0) {
            return true;
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        HashMap<IDoc, Exception> hashMap = new HashMap<IDoc, Exception>();
        int n = 0;
        while (n < objectArray.length) {
            block8: {
                IPersistable iPersistable = ((DocWorkbenchAdapter)objectArray[n]).getPersistable();
                try {
                    if (!iPersistable.doSave((IProgressMonitor)nullProgressMonitor)) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    if (!(iPersistable instanceof IDoc)) break block8;
                    hashMap.put((IDoc)((Object)iPersistable), iOException);
                }
            }
            ++n;
        }
        if (!hashMap.isEmpty()) {
            app.docBoss().handleDocExceptions(hashMap);
            return false;
        }
        return true;
    }

    public DiffDoc(Builder builder) {
        boolean bl;
        IResource[] iResourceArray;
        Object object;
        this.timeOpened = builder.timeOpened;
        this.timeCreated = builder.timeCreated;
        this.historyEntry = builder.historyEntry;
        this.sync2WayOp = builder.sync2WayOp;
        assert (this.extensions.isEmpty());
        this.extensions.putAll(builder.extensions);
        if (builder.prefs != null) {
            if (builder.prefs instanceof OverlayPrefStore) {
                this.setPreferences(builder.prefs);
            } else {
                this.setPreferences(PrefUtil.cloneSessionPrefs(builder.prefs));
            }
        } else {
            this.setPreferences(PrefUtil.createSessionPrefs());
        }
        this.name = builder.name;
        this.mergedUI = builder.mergedUI;
        this.id = builder.docId != null ? builder.docId : UUID.randomUUID();
        this.cType = builder.cType;
        if (this.cType.isUnknown() && !UriInfoUtil.isEmpty(builder.uriInfos)) {
            this.cType = app.contentTypeBoss().detectType(builder.uriInfos, null);
        }
        DocType docType = DocType.fromJson(this.cType.docTypeKey());
        UriInfoUtil.makeUriInfosSafe(builder.uriInfos, null);
        assert (this.uriInfos.isEmpty());
        this.uriInfos.putAll(builder.uriInfos);
        for (Map.Entry<Role, UriInfo> entry : this.uriInfos.entrySet()) {
            object = entry.getKey();
            iResourceArray = entry.getValue();
            if (iResourceArray.snapshotPath().isEmpty() || iResourceArray.snapshotTrees().containsKey(object)) continue;
            this.readSnapshot(iResourceArray.snapshotPath());
            break;
        }
        boolean bl2 = bl = !UriInfoUtil.isEmpty(this.uriInfos);
        if (builder.force3Way) {
            this.setThreeWayImpl(true, bl, false);
        } else {
            this.threeWay = this.readThreeWayFromPrefs(bl);
        }
        IFilterBoss iFilterBoss = app.filterBoss();
        if (builder.filtersId != null) {
            object = iFilterBoss.getSessionFilters(builder.filtersId);
            this.filtersId = Filters.shouldCloneFilter(object.docType(), docType) ? iFilterBoss.cloneSessionFilters((IFilters)object, docType).id() : null;
        }
        object = (IDocFactory[])ArrayUtil.copyOf((Object[])builder.factories, (int)builder.factories.length);
        iResourceArray = (IResource[])ArrayUtil.copyOf((Object[])builder.resources, (int)builder.resources.length);
        this.createDocTriads((IDocFactory[])object, iResourceArray, this.uriInfos);
        if (this.filtersId == null) {
            DocType docType2 = null;
            if (docType.isStructure()) {
                docType2 = DocType.FOLDER;
            } else if (docType.isText() || docType == DocType.BINARY || docType == DocType.UNKNOWN) {
                docType2 = DocType.TEXT;
            }
            if (docType2 != null) {
                this.filtersId = iFilterBoss.createSessionFilters(docType2).id();
            }
        }
        this.beInHistory = builder.beInHistory;
        if (!docType.isStructure() && builder.mergedUI != null) {
            this.doc(0, Role.REF).setMergedUriInfo(builder.mergedUI);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Constructed with Builder: " + builder);
        }
    }

    public DiffDoc(JsonReader jsonReader, String string) throws IOException {
        this.setPreferences(PrefUtil.createSessionPrefs());
        Set<Role> set = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            Object object;
            String string2 = jsonReader.nextName();
            if (string2.equals("ver")) {
                jsonReader.skipValue();
                continue;
            }
            if (string2.equals("dtp")) {
                this.cType = DocType.fromString(jsonReader.nextString()).contentType();
                continue;
            }
            if (string2.equals("tp")) {
                if (StateBoss.is(Pre.V_20)) {
                    object = FileType.fromString((String)jsonReader.nextString());
                    DocType docType = object == FileType.FOLDER ? DocType.FOLDER : DocType.TEXT;
                    this.cType = docType.contentType();
                    continue;
                }
                jsonReader.skipValue();
                continue;
            }
            if (string2.equals("nm")) {
                this.name = jsonReader.nextString();
                continue;
            }
            if (string2.equals("dt")) {
                this.timeCreated = jsonReader.nextLong();
                continue;
            }
            if (string2.equals("lo") || StateBoss.is(Pre.V_21) && string2.equals("lat")) {
                this.timeOpened = jsonReader.nextLong();
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("READ: " + this.toString() + "     " + TimeFormatter.formatShort(this.timeOpened));
                continue;
            }
            if (string2.equals("fav")) {
                this.favorite = jsonReader.nextBoolean();
                continue;
            }
            if (string2.equals("op")) {
                this.hasOpenView = jsonReader.nextBoolean();
                continue;
            }
            if (string2.equals("s2")) {
                this.sync2WayOp = Sync2WayOp.fromInt(jsonReader.nextInt());
                continue;
            }
            if (string2.equals("prefs")) {
                this.readPrefs(jsonReader);
                continue;
            }
            if (StateBoss.is(Pre.V_21) && string2.equals("filters")) {
                object = new Filters(jsonReader, this.docType());
                this.filtersId = object.id();
                app.filterBoss().addSessionFilters((IFilters)object);
                continue;
            }
            if (string2.equals("io")) {
                assert (this.uriInfos.isEmpty());
                this.uriInfos.putAll(UriInfoUtil.readUriInfos(jsonReader));
                continue;
            }
            if (string2.equals("ver")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("snapshot version: " + jsonReader.nextString());
                    continue;
                }
                jsonReader.skipValue();
                continue;
            }
            if (string2.equals("snapshot")) {
                this.readSnapshot(jsonReader, set, string);
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string2);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        this.threeWay = UriInfoUtil.isThreeWay(this.uriInfos);
        if (this.timeOpened == 0L) {
            this.timeOpened = System.currentTimeMillis();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Constructed from history: " + this.toString());
        }
    }

    @Override
    public void addDiffDocListener(IDiffDocListener iDiffDocListener) {
        this.addListenerObject(iDiffDocListener);
    }

    @Override
    public void allowReadOnlyEdit(boolean bl) {
        for (Map<Role, IDoc> map : this.docTriads) {
            for (IDoc iDoc : map.values()) {
                iDoc.allowReadOnlyEdit(bl);
            }
        }
    }

    @Override
    public void clearUriInfoErrors() {
        Set<Role> set = this.roles();
        for (Role role : set) {
            if (!this.uriInfo(role).hasError()) continue;
            this.updateUriInfo(role, UriInfo.Field.ERROR, null);
        }
    }

    @Override
    public int compareTo(IDiffDoc iDiffDoc) {
        long l = this.timeOpened - iDiffDoc.getTimeLastOpened();
        if (l == 0L) {
            l = this.timeCreated - iDiffDoc.getTimeCreated();
        }
        if (l != 0L) {
            return l > 0L ? -1 : 1;
        }
        for (Map.Entry<Role, UriInfo> entry : this.uriInfos.entrySet()) {
            int n;
            String string = entry.getValue().uri();
            String string2 = iDiffDoc.uriInfo(entry.getKey()).uri();
            int n2 = n = OS.LINUX ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
            if (n == 0) continue;
            this.id = UUID.randomUUID();
            return n;
        }
        return this.id.compareTo(iDiffDoc.getId());
    }

    @Override
    public ContentType contentType() {
        return this.cType.isUnknown() ? this.docType(0).contentType() : this.cType;
    }

    protected IDoc createDoc(IDocFactory iDocFactory, Role role, IResource iResource) {
        return iDocFactory.createDoc(this, role, iResource, this.cType);
    }

    protected void createDocTriad(IDocFactory iDocFactory, IResource[] iResourceArray) {
        EnumMap<Role, IDoc> enumMap = new EnumMap<Role, IDoc>(Role.class);
        for (Role role : Relation.roles(true)) {
            String string;
            String string2;
            IResource iResource = iResourceArray[role.toInt()];
            IDoc iDoc = this.createDoc(iDocFactory, role, iResource);
            enumMap.put(role, iDoc);
            if (iResource == null || (string2 = iResource.getUri()).equals(string = iResource.getDisplayUri())) continue;
            UriInfo uriInfo = this.uriInfos.get((Object)role);
            Map<UriInfoKey, Object> map = uriInfo.properties();
            map = new HashMap<UriInfoKey, Object>(map);
            map.put(UriInfoKey.DISPLAY_URI, string);
            this.uriInfos.put(role, new UriInfo(string2, uriInfo.fileType(), map));
        }
        this.docTriads.add(enumMap);
    }

    protected void createDocTriads(IDocFactory[] iDocFactoryArray, IResource[] iResourceArray, Map<Role, UriInfo> map) {
        if (iResourceArray.length == 0) {
            iResourceArray = new IResource[Role.count()];
        }
        if (iDocFactoryArray.length == 0) {
            boolean bl = this.preferences().getBoolean(PrefKey.C_FOLLOW_SYMLINKS.toString());
            iDocFactoryArray = DocFactory.getFactories(map, iResourceArray, bl, FileType.FILE);
        }
        IDocFactory[] iDocFactoryArray2 = iDocFactoryArray;
        int n = iDocFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocFactory iDocFactory = iDocFactoryArray2[n2];
            this.createDocTriad(iDocFactory, iResourceArray);
            ++n2;
        }
    }

    @Override
    public final IDiffModel diffModel(int n) {
        DocType docType;
        IDocFactory iDocFactory;
        IDiffModel iDiffModel;
        if (n < 0 && n >= this.triadCount()) {
            throw new IndexOutOfBoundsException("modelIx");
        }
        if (n >= this.models.size() && (iDiffModel = (iDocFactory = DocFactory.getFactory((docType = this.docType(n)).factoryId())).createDiffModel(this)) != null) {
            this.models.add(iDocFactory.createDiffModel(this));
        }
        return n >= this.models.size() ? null : this.models.get(n);
    }

    @Override
    public List<IDiffModel> diffModels() {
        return Collections.unmodifiableList(this.models);
    }

    @Override
    public Image dimImage(Image image) {
        Image image2 = this.img2dimImg.get(image);
        if (image2 == null) {
            if (OS.OSX) {
                image2 = !UIUtil.isRetina() ? image.createDimCopy(160) : image;
                this.img2dimImg.put(image, image2);
                return image2;
            }
            ImageData imageData = image.getImageData();
            image2 = OS.WIN || imageData.alphaData != null && imageData.width * imageData.height == imageData.alphaData.length ? new Image(image.getDevice(), ImageDataUtil.setAlpha(imageData, 0.35)) : new Image(image.getDevice(), image, 1);
            this.img2dimImg.put(image, image2);
        }
        return image2;
    }

    @Override
    public Map<Role, IDoc> dirtyDocs(int n) {
        Map<Role, IDoc> map = this.triad(n);
        LinkedHashMap<Role, IDoc> linkedHashMap = new LinkedHashMap<Role, IDoc>();
        for (Map.Entry<Role, IDoc> entry : map.entrySet()) {
            IDoc iDoc = entry.getValue();
            if (!(iDoc instanceof IPersistable) || !((IPersistable)((Object)iDoc)).isModified()) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    @Override
    public String displayCreationTime() {
        return TimeFormatter.formatShort(this.timeCreated);
    }

    @Override
    public String displayName() {
        if (!this.getName().isEmpty()) {
            return this.getName();
        }
        if (UriInfoUtil.isEmpty(this.uriInfos)) {
            return "";
        }
        Iterator<Role> iterator = this.roles().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Role role = iterator.next();
            stringBuilder.append(FileUtil.getFileName((String)this.uriInfos.get((Object)role).displayUri()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(NAME_SEPARATOR);
        }
        boolean bl = true;
        if (bl) {
            return stringBuilder.toString();
        }
        return String.valueOf(stringBuilder.toString()) + "     :     " + this.displayPath();
    }

    @Override
    public String displayPath() {
        Object object2;
        boolean bl = true;
        Iterator<Role> iterator = this.roles().iterator();
        String string = FileUtil.getPathStem((String)this.uriInfos.get((Object)iterator.next()).uri());
        for (Object object2 : this.roles()) {
            if (string.equals(FileUtil.getPathStem((String)this.uriInfos.get(object2).uri()))) continue;
            bl = false;
            break;
        }
        if (bl) {
            return string;
        }
        object2 = FileUtil.getPathStem((String)this.uriInfos.get((Object)Relation.firstRole(this.threeWay)).uri());
        String string2 = FileUtil.getPathStem((String)this.uriInfos.get((Object)Relation.lastRole(this.threeWay)).uri());
        String string3 = DiffDoc.longestSubstring((String)object2, string2);
        iterator = this.roles().iterator();
        String string4 = FileUtil.getPathStem((String)this.uriInfos.get((Object)iterator.next()).uri());
        StringBuilder stringBuilder = new StringBuilder(!string3.isEmpty() ? string3 : "");
        iterator = this.roles().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Role role = iterator.next();
            string4 = FileUtil.getPathStem((String)this.uriInfos.get((Object)role).uri());
            if (string4.isEmpty()) continue;
            if (string3.isEmpty()) {
                stringBuilder.append(string4);
                continue;
            }
            if (bl2) {
                stringBuilder.append(NAME_SEPARATOR);
            } else {
                stringBuilder.append("   ");
            }
            bl2 = true;
            stringBuilder.append("..." + string4.substring(string3.length(), string4.length()));
        }
        return stringBuilder.toString();
    }

    @Override
    public void dispose() {
        this.reduceToHistoryEntry();
        if (this.isEmpty() || app.docBoss().get(this.id) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Disposing: " + this.toString());
            }
            if (this.filtersId != null) {
                app.filterBoss().removeSessionFilters(this.filtersId);
            }
            this.prefs = null;
        }
    }

    @Override
    public IDoc doc(int n, Role role) {
        return this.triad(n).get((Object)role);
    }

    @Override
    public DocType docType() {
        return this.docType(0);
    }

    @Override
    public DocType docType(int n) {
        if (this.isEmpty()) {
            return DocType.fromJson(this.cType.docTypeKey());
        }
        Map<Role, IDoc> map = this.triad(n);
        for (IDoc iDoc : map.values()) {
            if (iDoc == null || iDoc.docType() == DocType.UNKNOWN) continue;
            return iDoc.docType();
        }
        return DocType.fromJson(this.cType.docTypeKey());
    }

    public boolean exists() {
        return false;
    }

    @Override
    public Map<Role, String> fileExtensions() {
        Object object;
        if (this.extensions.isEmpty()) {
            Map.Entry<Role, String> entry = Relation.roles(true);
            object = entry.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                this.extensions.put((Role)((Object)object2), "");
            }
        }
        for (Map.Entry<Role, String> entry : this.extensions.entrySet()) {
            String string;
            if (!StringUtil.isEmpty((String)((String)entry.getValue())) || (object = this.doc(0, (Role)((Object)entry.getKey())).resource()) == null || StringUtil.isEmpty((String)(string = object.getExtension()))) continue;
            entry.setValue(string);
        }
        return this.extensions;
    }

    @Override
    public FileType fileType() {
        return this.cType.isStructure() ? FileType.FOLDER : FileType.FILE;
    }

    @Override
    public IFilters filters() {
        IFilters iFilters = app.filterBoss().getSessionFilters(this.filtersId);
        return iFilters;
    }

    public void fireComparing() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof IDiffDocListener) {
                ((IDiffDocListener)object).comparing();
            }
            ++n2;
        }
    }

    public void fireDone() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof IDiffDocListener) {
                ((IDiffDocListener)object).done();
            }
            ++n2;
        }
    }

    private void fireNameChanged() {
        final DocBoss docBoss = (DocBoss)app.docBoss();
        final Display display = UIUtil.display();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    docBoss.fireHistoryChanged(IDocBoss.ChangeEvent.Type.NAME, DiffDoc.this);
                }
            }
        });
    }

    protected void fireThreeWayChanged(boolean bl, boolean bl2) {
        Object[] objectArray;
        if (bl == bl2) {
            return;
        }
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof IDiffDocListener) {
                ((IDiffDocListener)object).threeWayChanged(this.threeWay);
            }
            ++n2;
        }
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    @Override
    public UUID getFiltersId() {
        return this.filtersId;
    }

    @Override
    public boolean getHasOpenView() {
        return this.hasOpenView;
    }

    @Override
    public com.deltawalker.script.HistoryEntry getHistoryEntry() {
        return this.historyEntry;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        DocType docType = this.triad(0).get((Object)Role.ONE).docType();
        String string = docType == DocType.FOLDER ? ImageConst.COMPARE_SELECTED_FOLDERS : ImageConst.OPEN_SELECTED;
        return ImageCache.getImageDescriptor(string);
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    @Override
    public Sync2WayOp getSync2WayOp() {
        return this.sync2WayOp;
    }

    private String getThreeWayKey(boolean bl) {
        String string = PrefKey.C_THREE_WAY.toString();
        string = bl ? string : String.valueOf(string) + '.' + (this.docType(0).isStructure() ? DocType.FOLDER.toJson() : DocType.TEXT.toJson());
        return string;
    }

    @Override
    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public long getTimeLastOpened() {
        return this.timeOpened;
    }

    protected String getTitle(IDoc iDoc) {
        return iDoc.getName();
    }

    public String getToolTipText() {
        if (this.docTriads.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        IDoc iDoc = this.doc(0, Relation.firstRole(this.threeWay));
        String string = iDoc.uriInfo().uri();
        if (string.isEmpty()) {
            string = iDoc.getName();
        }
        stringBuilder.append(String.valueOf(string) + '\n');
        if (this.threeWay) {
            iDoc = this.doc(0, Role.REF);
            string = iDoc.uriInfo().uri();
            if (string.isEmpty()) {
                string = iDoc.getName();
            }
            stringBuilder.append(String.valueOf(string) + '\n');
        }
        if ((string = (iDoc = this.doc(0, Relation.lastRole(this.threeWay))).uriInfo().uri()).isEmpty()) {
            string = iDoc.getName();
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public String getUniqueName() {
        return String.valueOf(this.getName()) + " " + TimeFormatter.formatShort(this.getTimeCreated());
    }

    public int hashCodeX() {
        int n = 17;
        n = 31 * n + this.fileType().hashCode();
        n = 31 * n + this.name.hashCode();
        Role[] roleArray = Role.values();
        int n2 = roleArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Role role = roleArray[n3];
            UriInfo uriInfo = this.uriInfo(role);
            if (uriInfo != null) {
                n = 31 * n + uriInfo.hashCode();
            }
            ++n3;
        }
        return n;
    }

    @Override
    public boolean hasSnapshot() {
        for (UriInfo uriInfo : this.uriInfos.values()) {
            if (uriInfo.snapshotPath().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        if (!UriInfoUtil.isEmpty(this.uriInfos)) {
            return false;
        }
        for (Map<Role, IDoc> map : this.docTriads) {
            for (IDoc iDoc : map.values()) {
                if (iDoc.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFavorite() {
        return this.favorite;
    }

    @Override
    public boolean isModified() {
        for (Map<Role, IDoc> map : this.docTriads) {
            for (IDoc iDoc : map.values()) {
                if (!(iDoc instanceof IPersistable) || !((IPersistable)((Object)iDoc)).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isThreeWay() {
        return this.threeWay;
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public String jobName() {
        return this.jobName;
    }

    @Override
    public UriInfo mergedUriInfo() {
        return this.mergedUI;
    }

    @Override
    public IPreferenceStore preferences() {
        if (this.prefs == null) {
            LOG.error("'prefs' must be a valid object.");
        }
        return this.prefs;
    }

    private void setPreferences(IPreferenceStore iPreferenceStore) {
        if (iPreferenceStore == null) {
            throw new IllegalArgumentException("prefs");
        }
        this.prefs = iPreferenceStore;
    }

    private void readPrefs(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            Object object;
            String string = jsonReader.nextName();
            if (string.equals("contentTypes")) {
                ((IJsonState)app.contentTypeBoss()).fromJson(jsonReader);
                continue;
            }
            if (string.equals("filters")) {
                object = new Filters(jsonReader, this.docType());
                this.filtersId = object.id();
                assert (this.filtersId != null);
                app.filterBoss().addSessionFilters((IFilters)object);
                continue;
            }
            object = PrefKey.fromString(string);
            if (object != null) {
                String string2 = PrefKey.deminify(object, jsonReader.nextString()).toString();
                this.prefs.putValue(string, string2);
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown PrefKey: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    private void readSnapshot(JsonReader jsonReader, Set<Role> set, String string) throws IOException {
        EnumMap<Role, StructFileInfo> enumMap = new EnumMap<Role, StructFileInfo>(Role.class);
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String object3 = jsonReader.nextName();
            if (object3.equals("roles")) {
                set = Relation.readRoles(jsonReader);
                if (set.size() == 1 && this.roles().size() == 2) {
                    Role role = set.iterator().next();
                    Role role2 = Relation.others(role, false).iterator().next();
                    this.uriInfos.put(role2, this.uriInfos.get((Object)role));
                    continue;
                }
                for (Map.Entry<Role, UriInfo> entry : this.uriInfos.entrySet()) {
                    if (set.contains((Object)entry.getKey())) continue;
                    entry.setValue(new UriInfo("", FileType.FOLDER));
                }
                continue;
            }
            if (!object3.equals("nd")) continue;
            if (set.size() == 1) {
                StructFileInfo structFileInfo = DiffDoc.readNode(jsonReader, null);
                enumMap.put(set.iterator().next(), structFileInfo);
                continue;
            }
            Map<Role, StructFileInfo> map = DiffDoc.readNode(jsonReader, null, set);
            for (Role role : set) {
                enumMap.put(role, map.get((Object)role));
            }
        }
        jsonReader.endObject();
        if (set != null) {
            for (Role role : set) {
                UriInfo uriInfo3 = this.uriInfos.get((Object)role);
                uriInfo3 = uriInfo3.cloneUpdateSnapshotPath(string);
                uriInfo3 = uriInfo3.cloneUpdateSnapshotTrees(enumMap);
                this.uriInfos.put(role, uriInfo3);
            }
        }
    }

    private void readSnapshot(String string) {
        block8: {
            JsonReader jsonReader = null;
            try {
                try {
                    jsonReader = StateBoss.getJsonReader(new File(string));
                    Set<Role> set = null;
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String string2 = jsonReader.nextName();
                        if (string2.equals("roles")) {
                            set = Relation.readRoles(jsonReader);
                            continue;
                        }
                        if (string2.equals("snapshot")) {
                            this.readSnapshot(jsonReader, set, string);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                    jsonReader.endObject();
                }
                catch (IOException iOException) {
                    LOG.error("Couldn't open snapshot: " + string, (Throwable)iOException);
                    StreamUtil.closeSilently((Closeable)jsonReader);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeSilently(jsonReader);
                throw throwable;
            }
            StreamUtil.closeSilently((Closeable)jsonReader);
        }
    }

    private boolean readThreeWayFromPrefs(boolean bl) {
        String string = this.getThreeWayKey(bl);
        IPreferenceStore iPreferenceStore = this.preferences();
        if (!bl) {
            iPreferenceStore.setDefault(string, false);
        }
        return iPreferenceStore.getBoolean(string);
    }

    private void reduceToHistoryEntry() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Reducing to history entry(): " + this.toString());
        }
        this.clearListeners();
        ListIterator<IDiffModel> listIterator = this.models.listIterator(this.models.size());
        while (listIterator.hasPrevious()) {
            listIterator.previous().dispose();
        }
        this.models.clear();
        for (Map<Role, IDoc> image : this.docTriads) {
            for (IDoc iDoc : image.values()) {
                iDoc.dispose();
            }
        }
        this.docTriads.clear();
        for (Image image : this.img2dimImg.values()) {
            image.dispose();
        }
        this.img2dimImg.clear();
    }

    @Override
    public void removeDiffDocListener(IDiffDocListener iDiffDocListener) {
        this.removeListenerObject(iDiffDocListener);
    }

    @Override
    public int roleCount() {
        return this.threeWay ? 3 : 2;
    }

    @Override
    public Set<Role> roles() {
        return Relation.roles(this.threeWay);
    }

    @Override
    public void setFavorite(boolean bl) {
        this.favorite = bl;
    }

    @Override
    public void setFiltersId(UUID uUID) {
        if (this.filtersId != null && uUID != null) {
            app.filterBoss().removeSessionFilters(this.filtersId);
        }
        this.filtersId = uUID;
    }

    @Override
    public void setHasOpenView(boolean bl) {
        this.hasOpenView = bl;
    }

    @Override
    public void setHistoryEntry(com.deltawalker.script.HistoryEntry historyEntry) {
        this.historyEntry = historyEntry;
        this.setHistoryId(this.id);
    }

    @Override
    public void setId(UUID uUID) {
        if (this.id != null) {
            app.docBoss().remove(this.id);
            this.setHistoryId(this.id);
        }
        this.id = uUID;
    }

    private void setHistoryId(UUID uUID) {
        if (this.historyEntry != null) {
            ((HistoryEntry)this.historyEntry).setId(this.id);
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("'name' must be a valid string");
        }
        if (!this.name.equals(string)) {
            this.name = string;
            this.fireNameChanged();
        }
    }

    @Override
    public void setSync2WayOp(Sync2WayOp sync2WayOp) {
        this.sync2WayOp = sync2WayOp;
    }

    @Override
    public void setThreeWay(boolean bl) {
        this.setThreeWayImpl(bl, !this.isEmpty(), true);
    }

    private void setThreeWayImpl(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.threeWay;
        if (bl4 != bl) {
            this.threeWay = bl;
            if (!bl) {
                this.updateUriInfo(Role.TWO, UriInfo.Field.URI, null);
            }
            this.preferences().setValue(this.getThreeWayKey(bl2), bl);
            if (bl3) {
                this.fireThreeWayChanged(bl4, bl);
            }
        }
    }

    @Override
    public void setTimeCreated(long l) {
        this.timeCreated = l;
    }

    @Override
    public void setTimeLastOpened(long l) {
        this.timeOpened = l;
    }

    @Override
    public void setWorking(boolean bl, String string) {
        this.working = bl;
        this.jobName = StringUtil.makeSafe((String)string);
    }

    @Override
    public boolean shouldBeInHistory() {
        return this.beInHistory && !UriInfoUtil.isEmpty(this.uriInfos);
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        this.prefs.setValue(this.getThreeWayKey(true), this.threeWay);
        DocType docType = this.docType();
        assert (docType != DocType.UNKNOWN);
        jsonWriter.name("dtp").value(docType.toJson());
        jsonWriter.name("nm").value(this.name);
        jsonWriter.name("lo").value(this.getTimeLastOpened());
        if (LOG.isInfoEnabled()) {
            LOG.info("WRITE: timeOpened=" + this.timeOpened + " " + this.toString());
        }
        jsonWriter.name("dt").value(this.getTimeCreated());
        jsonWriter.name("fav").value(this.favorite);
        jsonWriter.name("op").value(this.hasOpenView);
        jsonWriter.name("s2").value((long)this.sync2WayOp.toInt());
        jsonWriter.name("io");
        UriInfoUtil.writeUriInfos(jsonWriter, this.uriInfos(), this.roles());
        jsonWriter.name("prefs");
        this.writePrefs(jsonWriter);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (!bl) {
            stringBuilder.append("cType:").append(this.cType);
            if (this.filtersId != null) {
                stringBuilder.append(" filtersId:").append(this.filtersId);
            }
            if (this.mergedUI != null && !this.mergedUI.isEmpty()) {
                stringBuilder.append(" mergedUI:").append(this.mergedUI.uri());
            }
            stringBuilder.append(" docId:").append(this.id);
            stringBuilder.append(" filtersId:").append(this.filtersId);
            stringBuilder.append(" timeCreated:").append(this.timeCreated);
            stringBuilder.append(" timeOpened:").append(this.timeOpened);
        }
        if (!UriInfoUtil.isEmpty(this.uriInfos)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(Const.LINE_ENDING);
            }
            stringBuilder.append('[');
            Iterator<Role> iterator = this.roles().iterator();
            while (iterator.hasNext()) {
                Role role = iterator.next();
                stringBuilder.append(this.uriInfos.get((Object)role));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<Role, IDoc> triad(int n) {
        if (this.docTriads.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.docTriads.get(n));
    }

    @Override
    public int triadCount() {
        return this.docTriads.size();
    }

    @Override
    public void updateUriInfo(Role role, UriInfo.Field field, Object object) {
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (field == null) {
            throw new NullPointerException("field");
        }
        switch (field) {
            case ALL: {
                this.uriInfos.put(role, (UriInfo)object);
                break;
            }
            case ENCODING: {
                this.uriInfos.put(role, this.uriInfos.get((Object)role).cloneUpdateEncoding((TextEncoding)object));
                break;
            }
            case ERROR: {
                this.uriInfos.put(role, this.uriInfos.get((Object)role).cloneUpdateError((Throwable)object));
                break;
            }
            case LINE_ENDING: {
                this.uriInfos.put(role, this.uriInfos.get((Object)role).cloneUpdateLineEnding((String)object));
                break;
            }
            case LOCALE: {
                this.uriInfos.put(role, this.uriInfos.get((Object)role).cloneUpdateLocale((Locale)object));
                break;
            }
            case URI: {
                this.uriInfos.put(role, this.uriInfos.get((Object)role).cloneUpdateUri((String)object, false));
                for (Map<Role, IDoc> map : this.docTriads) {
                    for (Map.Entry<Role, IDoc> entry : map.entrySet()) {
                        if (entry.getKey() != role) continue;
                        entry.getValue().clear();
                    }
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public UriInfo uriInfo(Role role) {
        if (role == null) {
            throw new NullPointerException("role");
        }
        return this.uriInfos.get((Object)role);
    }

    @Override
    public Map<Role, UriInfo> uriInfos() {
        UriInfoUtil.makeUriInfosSafe(this.uriInfos, this.docType(0).fileType());
        return this.uriInfos;
    }

    private void writePrefs(JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        for (PrefKey object2 : PrefKey.sessionKeys()) {
            object2.toJsonWriter(jsonWriter, this.prefs.getString(object2.toString()));
        }
        IFilters iFilters = app.filterBoss().getSessionFilters(this.filtersId);
        if (iFilters != null) {
            jsonWriter.name("filters");
            ((IJsonState)iFilters).toJson(jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static class Builder {
        private static IDocFactory[] EMPTY_FACTORIES = new IDocFactory[0];
        private static IResource[] EMPTY_RESOURCES = new IResource[0];
        private boolean beInHistory = true;
        private ContentType cType = ContentType.UNKNOWN;
        private UUID docId = null;
        private Map<Role, String> extensions = new EnumMap<Role, String>(Role.class);
        private IDocFactory[] factories = EMPTY_FACTORIES;
        private UUID filtersId = null;
        private boolean force3Way = false;
        private com.deltawalker.script.HistoryEntry historyEntry;
        private UriInfo mergedUI;
        private String name = "";
        private IPreferenceStore prefs = null;
        private IResource[] resources = EMPTY_RESOURCES;
        private Sync2WayOp sync2WayOp = Sync2WayOp.NONE;
        private long timeCreated = System.currentTimeMillis();
        private long timeOpened = System.currentTimeMillis();
        private Map<Role, UriInfo> uriInfos = new EnumMap<Role, UriInfo>(Role.class);

        public Builder beInHistory(boolean bl) {
            this.beInHistory = bl;
            return this;
        }

        public IDiffDoc build() {
            if (this.factories.length > 0) {
                return this.factories[this.factories.length - 1].createDiffDoc(this);
            }
            return new DiffDoc(this);
        }

        public Builder contentType(ContentType contentType) {
            this.cType = contentType;
            return this;
        }

        public IDocFactory[] docFactories() {
            return this.factories;
        }

        public Builder docFactories(IDocFactory[] iDocFactoryArray) {
            if (iDocFactoryArray != null) {
                this.factories = iDocFactoryArray;
            }
            return this;
        }

        public Map<Role, String> fileExtensions() {
            return this.extensions;
        }

        public Builder fileExtensions(Map<Role, String> map) {
            this.extensions = map;
            return this;
        }

        public UUID filtersId() {
            return this.filtersId;
        }

        public Builder filtersId(UUID uUID) {
            this.filtersId = uUID;
            return this;
        }

        public Builder force3Way(boolean bl) {
            this.force3Way = bl;
            return this;
        }

        public Builder historyEntry(com.deltawalker.script.HistoryEntry historyEntry) {
            this.historyEntry = historyEntry;
            return this;
        }

        public Builder id(UUID uUID) {
            this.docId = uUID;
            return this;
        }

        public Builder mergedUI(UriInfo uriInfo) {
            this.mergedUI = uriInfo;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Builder name(String string) {
            this.name = string;
            return this;
        }

        public Builder prefs(IPreferenceStore iPreferenceStore) {
            this.prefs = iPreferenceStore;
            return this;
        }

        public IResource[] resources() {
            return this.resources;
        }

        public Builder resources(IResource[] iResourceArray) {
            if (iResourceArray != null) {
                this.resources = iResourceArray;
            }
            return this;
        }

        public Builder sync2WayOp(Sync2WayOp sync2WayOp) {
            this.sync2WayOp = sync2WayOp;
            return this;
        }

        public Builder timeCreated(long l) {
            this.timeCreated = l;
            return this;
        }

        public Builder timeOpened(long l) {
            this.timeOpened = l;
            return this;
        }

        public String toString() {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.factories.length > 0) {
                stringBuilder.append(" [");
                IDocFactory[] iDocFactoryArray = this.factories;
                int n = this.factories.length;
                int n2 = 0;
                while (n2 < n) {
                    object = iDocFactoryArray[n2];
                    stringBuilder.append(String.valueOf(object.id()) + " ");
                    ++n2;
                }
                stringBuilder.append(']');
            }
            stringBuilder.append(" cType:" + this.cType);
            if (this.filtersId != null) {
                stringBuilder.append(" filtersId:" + this.filtersId);
            }
            if (this.force3Way) {
                stringBuilder.append(" force3Way:" + this.force3Way);
            }
            if (this.mergedUI != null && !this.mergedUI.isEmpty()) {
                stringBuilder.append(" mergedUI:" + this.mergedUI.uri());
            }
            if (this.docId != null) {
                stringBuilder.append(" docId:" + this.docId);
            }
            stringBuilder.append(" timeCreated:" + this.timeCreated);
            if (!UriInfoUtil.isEmpty(this.uriInfos)) {
                stringBuilder.append(String.valueOf(Const.LINE_ENDING) + "[");
                object = Relation.roles(this.force3Way).iterator();
                while (object.hasNext()) {
                    Role role = (Role)((Object)object.next());
                    stringBuilder.append(this.uriInfos.get((Object)role));
                    if (!object.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(']');
            } else {
                stringBuilder.append(" empty doc");
            }
            return stringBuilder.toString();
        }

        public Map<Role, UriInfo> uriInfos() {
            return this.uriInfos;
        }

        public Builder uriInfos(Map<Role, UriInfo> map) {
            this.uriInfos = map;
            return this;
        }
    }
}

