/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Delta;
import com.deltawalker.Msg;
import com.deltawalker.Relation;
import com.deltawalker.script.Delta;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DeltaUtil {
    public static final Delta ADDED;
    public static final Delta CHANGED;
    public static final Delta CONFLICT;
    public static final Delta DELETED;
    private static final Set<Delta> DELTAS;
    private static final Map<Relation, Delta.Kind> KIND_CONFLICT;
    public static final Delta SAME;
    private static final Set<Delta> umDELTAS;
    private static final Map<Relation, Delta.Kind> umKIND_CONFLICT;

    static {
        DELTAS = new LinkedHashSet<Delta>();
        KIND_CONFLICT = new EnumMap<Relation, Delta.Kind>(Relation.class);
        umDELTAS = Collections.unmodifiableSet(DELTAS);
        umKIND_CONFLICT = Collections.unmodifiableMap(KIND_CONFLICT);
        KIND_CONFLICT.put(Relation.REF_ONE, Delta.Kind.CHANGED);
        KIND_CONFLICT.put(Relation.REF_TWO, Delta.Kind.CHANGED);
        KIND_CONFLICT.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
        ADDED = new Delta(Delta.Kind.ADDED);
        DELTAS.add(ADDED);
        DELETED = new Delta(Delta.Kind.DELETED);
        DELTAS.add(DELETED);
        CHANGED = new Delta(Delta.Kind.CHANGED);
        DELTAS.add(CHANGED);
        SAME = new Delta(Delta.Kind.SAME);
        DELTAS.add(SAME);
        CONFLICT = new Delta(DeltaUtil.conflictKind());
        DELTAS.add(CONFLICT);
    }

    public static Map<Relation, Delta.Kind> conflictKind() {
        return umKIND_CONFLICT;
    }

    public static Set<Delta> deltas() {
        return umDELTAS;
    }

    public static String displayName(Delta delta) {
        if (delta == ADDED) {
            return Msg.DeltaKind_added;
        }
        if (delta == DELETED) {
            return Msg.DeltaKind_deleted;
        }
        if (delta == CHANGED) {
            return Msg.DeltaKind_changed;
        }
        if (delta == CONFLICT) {
            return Msg.DeltaKind_conflicting;
        }
        if (delta == SAME) {
            return Msg.DeltaKind_same;
        }
        throw new IllegalArgumentException("delta");
    }

    public static Map<Relation, Delta.Kind> sameKind(boolean bl) {
        EnumMap<Relation, Delta.Kind> enumMap = new EnumMap<Relation, Delta.Kind>(Relation.class);
        enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
        if (bl) {
            enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
            enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
        }
        return enumMap;
    }

    private DeltaUtil() {
    }
}

