/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.script.Comparison;
import com.deltawalker.script.Delta;
import java.util.Set;

public class DeltaNodeDetail
implements com.deltawalker.script.DeltaNodeDetail {
    public final int added;
    public final int deleted;
    public final int different;
    public final Set<Comparison.Method> method;
    public final long timeDelta;
    public final int total;

    public DeltaNodeDetail(Set<Comparison.Method> set, int n) {
        this(set, n, -1L);
    }

    public DeltaNodeDetail(Set<Comparison.Method> set, int n, int n2, int n3) {
        this(set, n, n2, n3, -1L);
    }

    public DeltaNodeDetail(Set<Comparison.Method> set, int n, int n2, int n3, long l) {
        this.method = set;
        this.added = n;
        this.deleted = n2;
        this.timeDelta = l;
        this.different = n3;
        this.total = n + n2 + n3;
    }

    public DeltaNodeDetail(Set<Comparison.Method> set, int n, long l) {
        this.method = set;
        this.added = 0;
        this.deleted = 0;
        this.timeDelta = l;
        this.different = 0;
        this.total = n;
    }

    @Override
    public int count(Delta.Kind[] kindArray) {
        if (kindArray == null) {
            throw new NullPointerException("'kinds' cannot be null.");
        }
        if (kindArray.length == 0) {
            throw new IllegalArgumentException("'kinds' cannot be empty.");
        }
        int n = 0;
        Delta.Kind[] kindArray2 = kindArray;
        int n2 = kindArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Delta.Kind kind = kindArray2[n3];
            if (kind == Delta.Kind.ADDED) {
                n += this.added;
            } else if (kind == Delta.Kind.DELETED) {
                n += this.deleted;
            } else if (kind == Delta.Kind.CHANGED) {
                n += this.different;
            }
            ++n3;
        }
        return n;
    }

    public int getAddedCount() {
        return this.added;
    }

    public int getChangedCount() {
        return this.different;
    }

    public int getDeletedCount() {
        return this.deleted;
    }

    @Override
    public Comparison.Method[] getMethod() {
        return this.method.toArray(new Comparison.Method[this.method.size()]);
    }

    @Override
    public long getTimeDelta() {
        return this.timeDelta;
    }

    public int getTotalCount() {
        return this.total;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method);
        stringBuilder.append(" added=" + this.added);
        stringBuilder.append(" deleted=" + this.deleted);
        stringBuilder.append(" different=" + this.different);
        stringBuilder.append(" total=" + this.total);
        return stringBuilder.toString();
    }
}

