/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Relation;
import com.deltawalker.RelationKindCombs;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltopia.util.Checker;
import com.deltopia.util.IDisposable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Delta
implements com.deltawalker.script.Delta,
IDisposable {
    private static final com.deltawalker.script.Delta[] NO_DIFFS = new com.deltawalker.script.Delta[0];
    private short kinds;
    protected Delta parent;

    public Delta() {
        this(Relation.REF_ONE, Delta.Kind.SAME);
    }

    public Delta(Delta.Kind kind) {
        this(Relation.REF_ONE, kind);
    }

    public Delta(Map<Relation, Delta.Kind> map) {
        Checker.notEmpty(map, (String)"kinds");
        this.setKinds(map);
    }

    public Delta(Relation relation, Delta.Kind kind) {
        this(Collections.singletonMap(relation, kind));
    }

    public void dispose() {
        this.kinds = 0;
        this.parent = null;
    }

    public boolean isDisposed() {
        return this.kinds == 0;
    }

    @Override
    public com.deltawalker.script.Delta[] getChildren() {
        return NO_DIFFS;
    }

    public Delta.Kind getKind(Relation relation) {
        return this.getKind(relation, false);
    }

    public Map<Relation, Delta.Kind> getKinds() {
        return RelationKindCombs.getKinds(this.kinds);
    }

    @Override
    public com.deltawalker.script.Delta getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @Override
    public boolean isAdded() {
        return this.isOverallKind(Delta.Kind.ADDED);
    }

    public boolean isAdded(Relation relation) {
        Delta.Kind kind = this.getKind(relation, true);
        return kind != null && kind == Delta.Kind.ADDED;
    }

    @Override
    public boolean isChanged() {
        return this.isOverallKind(Delta.Kind.CHANGED);
    }

    public boolean isChanged(Relation relation) {
        Delta.Kind kind = this.getKind(relation, true);
        return kind != null && kind == Delta.Kind.CHANGED;
    }

    @Override
    public boolean isConflict() {
        if (!this.isThreeWay()) {
            return false;
        }
        if (this.getKind(Relation.REF_ONE, true) == Delta.Kind.SAME) {
            return false;
        }
        if (this.getKind(Relation.REF_TWO, true) == Delta.Kind.SAME) {
            return false;
        }
        return this.getKind(Relation.ONE_TWO, true) != Delta.Kind.SAME;
    }

    @Override
    public boolean isDeleted() {
        return this.isOverallKind(Delta.Kind.DELETED);
    }

    public boolean isOverallKind(com.deltawalker.script.Delta delta) {
        boolean bl = delta.isConflict();
        return bl && this.isConflict() || delta.isPseudoConflict() && this.isPseudoConflict() || !bl && delta.isChanged() && this.isChanged() || delta.isAdded() && this.isAdded() || delta.isDeleted() && this.isDeleted();
    }

    @Override
    public boolean isOverallKind(Delta.Kind kind) {
        Map<Relation, Delta.Kind> map = this.getKinds();
        boolean bl = false;
        for (Delta.Kind kind2 : map.values()) {
            if (kind2 == null) continue;
            if (kind2 == kind) {
                bl = true;
                continue;
            }
            if (kind2 == Delta.Kind.SAME) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean isPseudoConflict() {
        if (!this.isThreeWay()) {
            return false;
        }
        Delta.Kind kind = this.getKind(Relation.REF_ONE);
        Delta.Kind kind2 = this.getKind(Relation.REF_TWO);
        Delta.Kind kind3 = this.getKind(Relation.ONE_TWO);
        return kind != Delta.Kind.SAME && kind2 != Delta.Kind.SAME && kind3 == Delta.Kind.SAME;
    }

    @Override
    public boolean isSame() {
        return this.isOverallKind(Delta.Kind.SAME);
    }

    public boolean isSame(Relation relation) {
        Delta.Kind kind = this.getKind(relation, true);
        return kind != null && kind == Delta.Kind.SAME;
    }

    protected boolean isThreeWay() {
        Map<Relation, Delta.Kind> map = this.getKinds();
        return map.size() == 3;
    }

    @Override
    public Delta.Kind kind(Role[] roleArray) {
        return this.getKind(Relation.fromArray(roleArray));
    }

    private String roles2string(Relation relation) {
        Set<Role> set = relation.toSet();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Role role : set) {
            stringBuilder.append((Object)role).append(", ");
        }
        if (!set.isEmpty()) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void setKind(Relation relation, Delta.Kind kind) {
        this.kinds = RelationKindCombs.setKind(this.kinds, relation, kind);
    }

    public void setKinds(Map<Relation, Delta.Kind> map) {
        this.kinds = RelationKindCombs.setKinds(map);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<Relation, Delta.Kind> map = this.getKinds();
        if (!map.isEmpty()) {
            stringBuilder.append(this.isThreeWay() ? "3-way: " : "2-way");
            for (Map.Entry<Relation, Delta.Kind> entry : map.entrySet()) {
                stringBuilder.append(this.roles2string(entry.getKey())).append(" -> ").append((Object)entry.getValue()).append("; ");
            }
        } else {
            stringBuilder.append("<Disposed>");
        }
        return stringBuilder.toString();
    }

    private final Delta.Kind getKind(Relation relation, boolean bl) {
        Delta.Kind kind = RelationKindCombs.getKind(this.kinds, relation);
        if (kind == null && !bl) {
            throw new IllegalArgumentException("No such relation: " + (Object)((Object)relation) + " in: " + this.toString());
        }
        return kind;
    }
}

