/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.DocType;
import com.deltawalker.resources.FileResource;
import com.deltopia.StringUtil;
import com.deltopia.io.FileUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class ContentTypeEntry
implements Comparable<ContentTypeEntry> {
    private final Change change;
    private final String description;
    private final DocType docType;
    private final String extension;
    private Image image;
    private String programName;

    public ContentTypeEntry(ContentTypeEntry contentTypeEntry, Change change) {
        this.extension = contentTypeEntry.extension;
        this.docType = contentTypeEntry.docType;
        this.description = contentTypeEntry.description;
        this.image = contentTypeEntry.image;
        this.programName = contentTypeEntry.programName;
        this.change = change;
    }

    public ContentTypeEntry(String string, DocType docType, String string2) {
        this(string, docType, string2, Change.SAME);
    }

    public ContentTypeEntry(String string, DocType docType, String string2, Change change) {
        if (string == null) {
            throw new NullPointerException("extension");
        }
        if (docType == null) {
            throw new NullPointerException("docType");
        }
        if (string2 == null) {
            throw new NullPointerException("description");
        }
        if (change == null) {
            throw new NullPointerException("change");
        }
        this.extension = StringUtil.makeSafe((String)string);
        this.docType = docType;
        this.description = StringUtil.makeSafe((String)string2);
        this.change = change;
    }

    public Change changed() {
        return this.change;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("docType=" + (Object)((Object)this.docType));
        if (this.change != Change.SAME) {
            stringBuilder.append(" " + this.change.name());
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(ContentTypeEntry contentTypeEntry) {
        return this.extension().compareToIgnoreCase(contentTypeEntry.extension());
    }

    public String description() {
        return this.description;
    }

    public DocType docType() {
        return this.docType;
    }

    public String extension() {
        return this.extension;
    }

    public Image image() {
        FileUtil.ProgramInfo programInfo;
        if (this.image == null && (programInfo = FileUtil.getImageFromExtension((String)this.extension(), (Point)FileResource.getImageSize())) != null) {
            this.image = programInfo.image;
            this.programName = programInfo.name;
        }
        return this.image;
    }

    public String programName() {
        if (this.programName == null) {
            this.image();
        }
        return this.programName;
    }

    public static enum Change {
        ADDED("a"),
        CHANGED("c"),
        DELETED("d"),
        SAME("s");

        private static final Map<String, Change> str2enum;
        private final String text;

        static {
            str2enum = new HashMap<String, Change>(4);
            Change[] changeArray = Change.values();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                str2enum.put(change.text, change);
                ++n2;
            }
        }

        public static Change fromString(String string) {
            return str2enum.get(string);
        }

        private Change(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }
}

