/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class BoldFontCache {
    private static Map<Font, Font> cache = new HashMap<Font, Font>();

    public static void dispose() {
        if (cache == null) {
            return;
        }
        Iterator<Font> iterator = cache.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        cache.clear();
    }

    public static Font get(Font font) {
        if (font == null) {
            return null;
        }
        if (cache.containsKey(font)) {
            return cache.get(font);
        }
        FontData[] fontDataArray = font.getFontData();
        FontData[] fontDataArray2 = new FontData[fontDataArray.length];
        int n = 0;
        while (n < fontDataArray.length) {
            FontData fontData = fontDataArray[n];
            fontDataArray2[n] = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle() | 1);
            ++n;
        }
        Font font2 = new Font(font.getDevice(), fontDataArray2);
        cache.put(font, font2);
        return font2;
    }

    private BoldFontCache() {
    }
}

