/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Addon;
import com.deltawalker.AddonException;
import com.deltopia.ClassUtil;
import com.deltopia.StringUtil;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public class AddonVerifier {
    public static final int CHUNK_MAX_LENGTH = 8;
    public static final char CHUNK_SEPARATOR = '-';
    private static final String KEY_ALIAS = "PublicDeltaWalkerCertificate";
    private static final char[] KEY_PWD = null;
    private static final char[] KEY_STORE_PWD = "087ee368-372e-11dc-8314-0800200c9a66".toCharArray();
    private byte[] byteAddon;
    private Signature signature;
    private final String strAddon;

    public static Signature createSignature(Class clazz, char[] cArray, String string, char[] cArray2, boolean bl) throws AddonException {
        Signature signature;
        try {
            signature = Signature.getInstance("SHA1withDSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AddonException(noSuchAlgorithmException);
        }
        Key key = AddonVerifier.loadCryptoKey(clazz, cArray, string, cArray2, bl);
        try {
            if (bl) {
                signature.initSign((PrivateKey)key);
            } else {
                signature.initVerify((PublicKey)key);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AddonException(invalidKeyException);
        }
        return signature;
    }

    private static Key loadCryptoKey(Class clazz, char[] cArray, String string, char[] cArray2, boolean bl) throws AddonException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException keyStoreException) {
            throw new AddonException(keyStoreException);
        }
        InputStream inputStream = clazz.getResourceAsStream(String.valueOf(ClassUtil.getSimpleName((Class)clazz)) + ".keystore");
        if (inputStream == null) {
            throw new AddonException("Couldn't load .keystore as stream.");
        }
        try {
            keyStore.load(inputStream, cArray);
        }
        catch (Exception exception) {
            throw new AddonException(exception);
        }
        Key key = null;
        try {
            key = bl ? keyStore.getKey(string, cArray2) : keyStore.getCertificate(string).getPublicKey();
        }
        catch (Exception exception) {
            throw new AddonException(exception);
        }
        if (bl && !(key instanceof PrivateKey) || !bl && !(key instanceof PublicKey)) {
            throw new AddonException();
        }
        return key;
    }

    private static String removeChunkSeparators(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.min(n2 + 8, n);
            stringBuffer.append(string.substring(n2, n3));
            n2 = n3 + 1;
        }
        return stringBuffer.toString();
    }

    public AddonVerifier(String string) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("licenseKey");
        }
        this.strAddon = AddonVerifier.removeChunkSeparators(string).trim();
    }

    private byte[] getLicenseKeyBytes() throws AddonException {
        if (this.byteAddon == null) {
            this.byteAddon = Base64.decodeBase64((String)this.strAddon);
        }
        return this.byteAddon;
    }

    private Signature getSignature() throws AddonException {
        if (this.signature == null) {
            this.signature = AddonVerifier.createSignature(AddonVerifier.class, KEY_STORE_PWD, KEY_ALIAS, KEY_PWD, false);
        }
        return this.signature;
    }

    public boolean verify(Addon addon) throws AddonException {
        byte[] byArray = this.getLicenseKeyBytes();
        if (byArray == null) {
            return false;
        }
        Signature signature = this.getSignature();
        byte[] byArray2 = addon.toBytes();
        try {
            signature.update(byArray2);
            return signature.verify(byArray);
        }
        catch (SignatureException signatureException) {
            throw new AddonException(signatureException);
        }
    }
}

