/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Addon;
import com.deltawalker.AddonException;
import com.deltawalker.AddonInfo;
import com.deltawalker.ExpiredAddonException;
import com.deltawalker.ImageCache;
import com.deltawalker.internal.ui.dialogs.TrialReminderDialog;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.dialogs.AddonInfoDialog;
import com.deltopia.io.FileInfo;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import com.deltopia.io.StreamUtil;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonInfoUtil {
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static boolean canShowAddonDlg = true;
    private static boolean canShowRemindDlg = true;
    private static Cipher cipher;
    private static File file;
    private static AddonInfo info;
    public static final int KEY_LINE_LENGTH = 60;
    private static final Logger LOG;
    private static SecretKey secret;
    public static final String TRIAL_KEY = "MC0CFCha-B6VCxE8D-L3yQ8zCZ-PUtb+F3E-AhUAkWkQ-SHKG7umL-TYEmVDg/-menFts0=";
    private static final int TRIAL_REMINDER_DAYS = 5;

    static {
        LOG = LoggerFactory.getLogger(AddonInfoUtil.class);
        try {
            DESKeySpec dESKeySpec = new DESKeySpec("Deltopia".getBytes("UTF-8"));
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            secret = secretKeyFactory.generateSecret(dESKeySpec);
            cipher = Cipher.getInstance("DES");
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't initialize key/cipher factory", throwable);
        }
    }

    public static AddonInfo addonInfo() {
        if (info == null) {
            Exception exception = null;
            File file = AddonInfoUtil.file();
            if (file.isFile()) {
                try {
                    info = AddonInfoUtil.load(file);
                }
                catch (IOException iOException) {
                    exception = iOException;
                }
                catch (AddonException addonException) {
                    exception = addonException;
                }
            }
            if (info == null) {
                info = new AddonInfo(exception == null ? TRIAL_KEY : null);
                AddonInfoUtil.save();
            }
        }
        return info;
    }

    private static String constructFileName(String string) {
        String string2 = DigestUtils.md5Hex((String)string).substring(0, 8);
        return string2;
    }

    public static String constructReminderMessage() {
        int n = AddonInfoUtil.remainingDays();
        return NLS.bind((String)UIMsg.AboutDlg_remainingDays, (Object)String.valueOf(n));
    }

    public static String constructSuffix(Set<Addon.Edition> set) {
        if (set.isEmpty() || set.contains((Object)AddonInfoUtil.addonInfo().edition())) {
            return "";
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (set.contains((Object)Addon.Edition.PRO) || set.contains((Object)Addon.Edition.ORO)) {
            linkedList.add(Addon.Edition.PRO.displayName());
            linkedList.add(Addon.Edition.ORO.displayName());
        }
        String string = "";
        if (!linkedList.isEmpty()) {
            string = NLS.bind((String)UIMsg.LicensedAction_availableIn_two, linkedList.get(0), linkedList.get(1));
        }
        return string;
    }

    private static File file() {
        if (file != null) {
            return file;
        }
        file = new File(Const.USER_HOME, String.valueOf('.') + AddonInfoUtil.constructFileName("dwk") + ".dwk");
        return file;
    }

    private static void hideFile(File file, boolean bl) {
        if (!OS.WIN) {
            return;
        }
        try {
            IFileSystem iFileSystem = IO.fileSystem();
            FileInfo fileInfo = iFileSystem.getFileInfo(file);
            if (bl != fileInfo.isHidden()) {
                int n = fileInfo.attributes();
                int n2 = bl ? n | 0x20 : n & 0xFFFFFFDF;
                FileInfo fileInfo2 = new FileInfo(fileInfo.name(), n2, 0L, 0L);
                iFileSystem.setFileInfo(AddonInfoUtil.file(), fileInfo2, 2);
            }
        }
        catch (IOException iOException) {
            LOG.error("Couldn't hide " + file, (Throwable)iOException);
        }
    }

    private static AddonInfo load(File file) throws IOException, AddonException {
        AddonInfo addonInfo;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
                string = bufferedReader.readLine();
            }
            byte[] byArray = Base64.decodeBase64((String)stringBuilder.toString());
            cipher.init(2, secret);
            String string2 = new String(cipher.doFinal(byArray));
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(string2));
            AddonInfo addonInfo2 = new AddonInfo();
            if (jsonReader != null) {
                addonInfo2.fromJson(jsonReader);
            }
            jsonReader.close();
            addonInfo = addonInfo2;
        }
        catch (Throwable throwable) {
            try {
                LOG.error("Couldn't read: " + file, throwable);
                throw new AddonException(throwable);
            }
            catch (Throwable throwable2) {
                StreamUtil.closeSilently(bufferedReader);
                throw throwable2;
            }
        }
        StreamUtil.closeSilently((Closeable)bufferedReader);
        return addonInfo;
    }

    public static String productVersion() {
        String string;
        String string2 = (String)Platform.getProduct().getDefiningBundle().getHeaders().get(BUNDLE_VERSION);
        if (string2 == null) {
            throw new IllegalStateException(BUNDLE_VERSION);
        }
        int n = string2.indexOf(46);
        String string3 = string = n == -1 ? string2 : string2.substring(0, n);
        if (string.length() == 0) {
            throw new IllegalStateException();
        }
        return string;
    }

    public static int remainingDays() {
        return AddonInfoUtil.remainingDays(info);
    }

    public static int remainingDays(AddonInfo addonInfo) {
        Date date = addonInfo.expirationDate();
        if (date != null) {
            double d = date.getTime() - new Date().getTime();
            return d <= 0.0 ? 0 : (int)Math.ceil(d / 8.64E7);
        }
        return -1;
    }

    private static int remindAboutExpiration() {
        int n = AddonInfoUtil.remainingDays(info);
        if (n < 0 || n > 5) {
            return 1027;
        }
        TrialReminderDialog trialReminderDialog = new TrialReminderDialog(null);
        trialReminderDialog.setImageDescriptor(ImageCache.getImageDescriptor("icons/DeltaWalker48x48.png"));
        trialReminderDialog.setMessage(MessageFormat.format(UIMsg.AddonInfoUtil_reminder, new Integer(n)));
        if (PlatformUI.isWorkbenchRunning()) {
            trialReminderDialog.setDefaultButtonText(UIMsg.AddonInfoUtil_continue);
        } else {
            trialReminderDialog.setDefaultButtonText(n == 0 ? UIMsg.AddonInfoUtil_quit : UIMsg.AddonInfoUtil_launch);
        }
        trialReminderDialog.setTitle(UIMsg.TrialReminderDlg_title);
        trialReminderDialog.setBuyNowURL(UIMsg.AddonInfoUtil_buyNowURL);
        canShowRemindDlg = false;
        return trialReminderDialog.open();
    }

    private static boolean requestNewLicense(boolean bl) {
        canShowAddonDlg = false;
        boolean bl2 = true;
        try {
            AddonInfo addonInfo;
            while (!(addonInfo = AddonInfoUtil.addonInfo()).isValid() || bl) {
                bl = false;
                AddonInfoDialog addonInfoDialog = new AddonInfoDialog(null, addonInfo);
                if (addonInfoDialog.open() == 0) {
                    info = addonInfoDialog.addonInfo();
                    AddonInfoUtil.save();
                    continue;
                }
                bl2 = false;
                break;
            }
        }
        finally {
            canShowAddonDlg = true;
        }
        return bl2;
    }

    public static void save() {
        File file;
        block6: {
            StringWriter stringWriter = null;
            PrintWriter printWriter = null;
            JsonWriter jsonWriter = null;
            file = AddonInfoUtil.file();
            try {
                try {
                    LOG.info("Saving info");
                    if (file.exists()) {
                        AddonInfoUtil.hideFile(file, false);
                    }
                    stringWriter = new StringWriter();
                    jsonWriter = new JsonWriter((Writer)stringWriter);
                    jsonWriter.beginObject();
                    info.toJson(jsonWriter);
                    jsonWriter.endObject();
                    byte[] byArray = stringWriter.toString().getBytes("UTF-8");
                    cipher.init(1, secret);
                    String string = Base64.encodeBase64String((byte[])cipher.doFinal(byArray));
                    printWriter = new PrintWriter(file);
                    printWriter.print(string);
                }
                catch (Throwable throwable) {
                    LOG.error("Couldn't save addon info: " + file, throwable);
                    StreamUtil.closeSilently(printWriter);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeSilently(printWriter);
                throw throwable;
            }
            StreamUtil.closeSilently((Closeable)printWriter);
        }
        AddonInfoUtil.hideFile(file, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int showAddonDialog(Shell shell, AddonInfo addonInfo) {
        if (!canShowAddonDlg) return 1;
        canShowAddonDlg = false;
        try {
            AddonInfoDialog addonInfoDialog = new AddonInfoDialog(shell, addonInfo);
            int n = addonInfoDialog.open();
            if (n != 0) return n;
            info = addonInfoDialog.addonInfo();
            AddonInfoUtil.save();
            return n;
        }
        finally {
            canShowAddonDlg = true;
        }
    }

    public static boolean validate() {
        boolean bl;
        int n = 1027;
        do {
            bl = false;
            if (n == 1026) continue;
            try {
                AddonInfoUtil.addonInfo().validate();
            }
            catch (AddonException addonException) {
                if (!(addonException instanceof ExpiredAddonException)) continue;
                bl = true;
            }
        } while ((!canShowAddonDlg || bl || AddonInfoUtil.requestNewLicense(n == 1026)) && canShowRemindDlg && (n = AddonInfoUtil.remindAboutExpiration()) == 1026);
        return AddonInfoUtil.addonInfo().isValid();
    }
}

