/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Addon;
import com.deltawalker.AddonException;
import com.deltawalker.ExpiredAddonException;
import com.deltawalker.MissingInfoAddonException;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonInfo
implements IJsonState {
    private static final Logger LOG = LoggerFactory.getLogger(AddonInfo.class);
    public static final int TRIAL_DAYS = 30;
    private Addon addon;
    private String key;
    private final Map<Param, Object> params = new EnumMap<Param, Object>(Param.class);

    public AddonInfo() {
        this(null);
    }

    public AddonInfo(String string) {
        if (!StringUtil.isEmpty((String)string)) {
            this.params.put(Param.KEY, string);
        }
    }

    public Addon addon() throws AddonException {
        String string = this.paramValueAsString(Param.KEY);
        if (this.key == null || !this.key.equals(string) || this.addon == null) {
            this.addon = Addon.recreate(string);
            this.key = string;
        }
        return this.addon;
    }

    public Addon.Edition edition() {
        try {
            return this.addon().edition();
        }
        catch (AddonException addonException) {
            return Addon.Edition.TRIAL;
        }
    }

    public Date expirationDate() {
        if (this.edition() == Addon.Edition.TRIAL && this.params.containsKey((Object)Param.TIME)) {
            long l = (Long)this.params.get((Object)Param.TIME);
            Calendar calendar = Calendar.getInstance();
            Date date = new Date(l);
            calendar.setTime(date);
            calendar.add(5, 30);
            return calendar.getTime();
        }
        return null;
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            Param param = Param.fromJson(string);
            Object object = string.equals(Param.TIME.toJson()) ? Long.valueOf(jsonReader.nextLong()) : jsonReader.nextString();
            assert (param != null);
            this.params.put(param, object);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("param=" + (Object)((Object)param) + "     value=" + object);
        }
        jsonReader.endObject();
    }

    public Object getParamValue(Param param) {
        return this.params.get((Object)param);
    }

    public boolean isValid() {
        try {
            return this.validate(false);
        }
        catch (AddonException addonException) {
            return false;
        }
    }

    public String paramValueAsString(Param param) {
        Object object = this.params.get((Object)param);
        return object != null ? object.toString() : "";
    }

    public void setParamValue(Param param, Object object) {
        this.params.put(param, object);
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        if (!this.params.containsKey((Object)Param.TIME)) {
            this.params.put(Param.TIME, Calendar.getInstance().getTimeInMillis());
        }
        for (Map.Entry<Param, Object> entry : this.params.entrySet()) {
            if (entry.getValue() == null) continue;
            String string = entry.getKey().toJson();
            if (entry.getKey() == Param.TIME) {
                jsonWriter.name(string).value((Number)Long.valueOf(this.params.get((Object)Param.TIME).toString()));
                continue;
            }
            String string2 = entry.getValue().toString();
            jsonWriter.name(string).value(string2);
        }
    }

    public String toString() {
        return this.params.toString();
    }

    public Addon.Type userType() {
        try {
            return this.addon().type();
        }
        catch (AddonException addonException) {
            return null;
        }
    }

    public void validate() throws AddonException {
        this.validate(true);
    }

    protected boolean validate(boolean bl) throws AddonException {
        Object object2;
        for (Object object2 : this.params.keySet()) {
            if (!object2.isRequired() || !this.paramValueAsString((Param)((Object)object2)).isEmpty()) continue;
            if (bl) {
                throw new MissingInfoAddonException();
            }
            return false;
        }
        try {
            this.addon();
        }
        catch (AddonException addonException) {
            if (bl) {
                throw addonException;
            }
            return false;
        }
        object2 = this.expirationDate();
        if (object2 != null && new Date().after((Date)object2)) {
            if (bl) {
                throw new ExpiredAddonException();
            }
            return false;
        }
        return true;
    }

    public static final class Param
    extends Enum<Param> {
        public static final /* enum */ Param EMAIL = new Param(UIMsg.AddonParam_email, true, "em", "email");
        public static final /* enum */ Param FIRM = new Param(UIMsg.AddonParam_firm, false, "fm", "company");
        public static final /* enum */ Param KEY = new Param(UIMsg.AddonParam_key, true, "k", "licenseKey");
        public static final /* enum */ Param NAME = new Param(UIMsg.AddonParam_name, true, "nm", "name");
        public static final /* enum */ Param TIME = new Param("Date Issued", true, "ts", "timestamp");
        private static final Map<String, Param> str2enum;
        final String dispName;
        final String json;
        final boolean required;
        final String text;
        private static final /* synthetic */ Param[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Param[]{EMAIL, FIRM, KEY, NAME, TIME};
            str2enum = new HashMap<String, Param>();
            Param[] paramArray = Param.values();
            int n = paramArray.length;
            int n2 = 0;
            while (n2 < n) {
                Param param = paramArray[n2];
                assert (!str2enum.containsKey(param.json));
                str2enum.put(param.json, param);
                ++n2;
            }
        }

        public static Param fromJson(String string) {
            return str2enum.get(string);
        }

        private Param(String string2, boolean bl, String string3, String string4) {
            this.dispName = string2;
            this.required = bl;
            this.json = string3;
            this.text = string4;
        }

        public String compatibilityString() {
            return this.text;
        }

        public String displayName() {
            return this.dispName;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toJson() {
            return this.json;
        }

        public static Param[] values() {
            Param[] paramArray = ENUM$VALUES;
            int n = paramArray.length;
            Param[] paramArray2 = new Param[n];
            System.arraycopy(ENUM$VALUES, 0, paramArray2, 0, n);
            return paramArray2;
        }

        public static Param valueOf(String string) {
            return Enum.valueOf(Param.class, string);
        }
    }
}

