/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.AddonException;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.AddonVerifier;
import com.deltawalker.Msg;
import com.deltopia.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import org.eclipse.core.runtime.Platform;

public class Addon {
    private Edition edition;
    private String os;
    private Type type;
    private String version;

    public static Addon recreate(String string) throws AddonException {
        if (StringUtil.isEmpty((String)string)) {
            throw new AddonException("'key' cannot be null or empty");
        }
        EnumSet<Edition> enumSet = EnumSet.allOf(Edition.class);
        EnumSet<Type> enumSet2 = EnumSet.allOf(Type.class);
        String string2 = AddonInfoUtil.productVersion();
        String string3 = Platform.getOS();
        AddonVerifier addonVerifier = new AddonVerifier(string);
        Addon addon = null;
        block0: for (Edition edition : enumSet) {
            if (addon != null) break;
            Addon addon2 = new Addon(edition, null, string3, string2);
            if (addonVerifier.verify(addon2)) {
                addon = addon2;
                break;
            }
            for (Type type : enumSet2) {
                addon2 = new Addon(edition, type, string3, string2);
                if (!addonVerifier.verify(addon2)) continue;
                addon = addon2;
                continue block0;
            }
        }
        if (addon == null) {
            throw new AddonException("Couldn't recreate addon");
        }
        return addon;
    }

    public Addon(Edition edition, Type type, String string, String string2) {
        if (edition == null) {
            throw new NullPointerException("edition");
        }
        if (string2 == null) {
            throw new NullPointerException("version");
        }
        this.type = type;
        this.edition = edition;
        this.os = edition.isSinglePlatform() ? string : null;
        this.version = string2;
    }

    public Edition edition() {
        return this.edition;
    }

    public boolean equals(Object object) {
        if (object instanceof Addon) {
            Addon addon = (Addon)object;
            return this.edition == addon.edition && this.type == addon.type && this.os.equals(addon.os) && this.version.equals(addon.version);
        }
        return false;
    }

    public byte[] toBytes() {
        String string = this.toString();
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return string.getBytes();
        }
    }

    public String toString() {
        String string = this.type != null ? this.type.constName() : "";
        String string2 = this.os != null ? this.os : "";
        String string3 = String.valueOf(this.edition.constName()) + '-' + string + '-' + string2 + '-' + this.version;
        return string3;
    }

    public Type type() {
        return this.type;
    }

    public static enum Edition {
        ORO(Msg.AddonEdition_oro, "oro"),
        PRO(Msg.AddonEdition_pro, "pro"),
        STANDARD(Msg.AddonEdition_standard, "standard"),
        TRIAL(Msg.AddonEdition_trial, "trial");

        private final String constName;
        private final String dispName;

        private Edition(String string2, String string3) {
            this.constName = string3;
            this.dispName = string2;
        }

        public String constName() {
            return this.constName;
        }

        public String displayName() {
            return this.dispName;
        }

        public boolean isSinglePlatform() {
            return this == STANDARD || this == PRO;
        }
    }

    public static enum Type {
        CMRL(Msg.AddonType_cmrlSingle, "commercial"),
        CMRL_ENTERPRISE(Msg.AddonType_cmrlEnterprise, "enterprise"),
        CMRL_SITE(Msg.AddonType_cmrlSite, "site"),
        PRSL(Msg.AddonType_personal, "personal");

        private final String constName;
        private final String dispName;

        private Type(String string2, String string3) {
            this.constName = string3;
            this.dispName = string2;
        }

        public String constName() {
            return this.constName;
        }

        public String displayName() {
            return this.dispName;
        }

        public boolean isCommercial() {
            return this == CMRL || this == CMRL_SITE || this == CMRL_ENTERPRISE;
        }
    }
}

