/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.App;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.product.application.internal.LaunchAdvisor;
import com.deltawalker.ui.UIUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.StreamUtil;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchRequestProcessor
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchRequestProcessor.class);
    private final Socket clientSocket;

    LaunchRequestProcessor(Socket socket) {
        super("LaunchRequestProcessor");
        this.clientSocket = socket;
    }

    private void launchWithArguments(final List<String> list) {
        if (list.size() <= 0) {
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = UIUtil.getActiveWindow();
                Shell shell = iWorkbenchWindow.getShell();
                if (!shell.isVisible()) {
                    shell.setVisible(true);
                }
                shell.forceActive();
                if (list.contains("ACTIVATE_APP_ON_FRONT")) {
                    if (list.size() > 1) {
                        LOG.warn("Unused arguments when activate: " + list);
                    }
                    LOG.info("Activate app window");
                } else {
                    String string;
                    UriInfo uriInfo = null;
                    int n = list.size() - 1;
                    while (n >= 0) {
                        string = (String)list.get(n);
                        if (string.toLowerCase().contains("-merged=")) {
                            uriInfo = new UriInfo(string.substring("-merged=".length(), string.length()).trim());
                            list.remove(n);
                        }
                        --n;
                    }
                    LaunchAdvisor.closeIntro(list, iWorkbenchWindow);
                    IDiffDoc iDiffDoc = LaunchAdvisor.getSessionOfType(list, FileType.FOLDER);
                    if (iDiffDoc != null) {
                        LaunchAdvisor.openSession(iDiffDoc, list, iWorkbenchWindow);
                    }
                    if ((string = LaunchAdvisor.getSessionOfType(list, FileType.FOLDER)) != null) {
                        LaunchAdvisor.openSession((IDiffDoc)string, list, iWorkbenchWindow);
                    }
                    Map map = UriInfo.processCmdLineArgs((List)list);
                    LOG.info("LaunchRequestProcessor.launchWithArguments()");
                    UriInfoUtil.log((Map)map);
                    App.instance().viewBoss().createDocView(map, null, null, false, uriInfo, false, true);
                }
                shell = UIUtil.getActiveWindowShell();
                shell.forceActive();
                shell.setMinimized(false);
            }
        });
    }

    @Override
    public void run() {
        try {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                PrintWriter printWriter = new PrintWriter(this.clientSocket.getOutputStream(), true);
                while ((string = bufferedReader.readLine()) != null) {
                    boolean bl = false;
                    if (string.equals("Hi, DeltaWalker, how are you doing?")) {
                        LOG.info("Read handshake request");
                        printWriter.println("Doing well, thank you.");
                        continue;
                    }
                    String[] stringArray = string.trim().split(":;:");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray2[n2];
                        if (string2.equalsIgnoreCase("-wait")) {
                            bl = true;
                        } else {
                            arrayList.add(string2);
                        }
                        ++n2;
                    }
                    if (arrayList != null && !arrayList.isEmpty()) {
                        this.launchWithArguments(arrayList);
                        try {
                            LaunchRequestProcessor.sleep(500L);
                            if (bl) continue;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            LOG.warn("Failed to wait files to be open", (Throwable)interruptedException);
                            continue;
                        }
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("No arguments passing " + this.clientSocket);
                }
                printWriter.println("done");
                bufferedReader.close();
                printWriter.close();
            }
            catch (IOException iOException) {
                LOG.warn("Failed make handshake " + this.clientSocket, (Throwable)iOException);
                StreamUtil.closeSilently((Closeable)this.clientSocket);
            }
        }
        finally {
            StreamUtil.closeSilently((Closeable)this.clientSocket);
        }
    }
}

