/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.product.application.internal.LaunchRequestProcessor;
import com.deltopia.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LaunchRequestListener
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.product.application.internal.LaunchRequestListener");
    private static File portFile;
    private final ServerSocket serverSocket = new ServerSocket();

    static File getPortFile() {
        if (portFile == null) {
            Location location = Platform.getInstanceLocation();
            portFile = new File(location.getURL().getFile(), ".DeltaWalker");
        }
        return portFile;
    }

    LaunchRequestListener() throws IOException {
        super("LaunchRequestListener");
        int n = 7777;
        int n2 = n + 10;
        while (n < n2) {
            try {
                this.serverSocket.bind(new InetSocketAddress("localhost", n));
                break;
            }
            catch (IOException iOException) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Failed to bind on port: " + n + ": " + iOException);
                }
                ++n;
            }
        }
        if (!this.serverSocket.isBound()) {
            throw new IOException("Could not bind to ports: 7777-7787");
        }
        try {
            this.savePortInFile();
        }
        catch (Throwable throwable) {
            LOG.warn("Failed to save port file: " + throwable);
            this.stopListening();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Failed to save port file", throwable);
        }
    }

    @Override
    public void run() {
        while (!this.serverSocket.isClosed()) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                LOG.warn("Failed to accept client connection: " + iOException);
                continue;
            }
            new LaunchRequestProcessor(socket).start();
        }
    }

    void stopListening() {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            StreamUtil.closeSilently((Closeable)this.serverSocket);
            File file = LaunchRequestListener.getPortFile();
            if (!file.delete() && file.exists()) {
                LOG.warn("Cannot delete port file " + file);
            }
        }
    }

    private void savePortInFile() throws IOException {
        File file = LaunchRequestListener.getPortFile();
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        int n = this.serverSocket.getLocalPort();
        Files.write(file.toPath(), Collections.singletonList(Integer.toString(n)), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        if (LOG.isInfoEnabled()) {
            LOG.info("Write port " + n + " to file: " + file);
        }
        file.deleteOnExit();
    }
}

