/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.App;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.product.application.internal.LaunchRequestListener;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.StreamUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchAdvisor {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchAdvisor.class);
    private int foundPort = -1;
    private LaunchRequestListener launchServer;

    public static boolean closeIntro(List<String> list, IWorkbenchWindow iWorkbenchWindow) {
        Map map = UriInfo.processCmdLineArgs(list);
        for (UriInfo uriInfo : map.values()) {
            if (uriInfo.isEmpty() || uriInfo.hasError()) continue;
            return LaunchAdvisor.closeIntro(iWorkbenchWindow);
        }
        return false;
    }

    public static boolean closeIntro(IWorkbenchWindow iWorkbenchWindow) {
        IIntroManager iIntroManager = iWorkbenchWindow.getWorkbench().getIntroManager();
        IIntroPart iIntroPart = iIntroManager.getIntro();
        return iIntroPart == null ? true : iIntroManager.closeIntro(iIntroPart);
    }

    public static IDiffDoc getSessionOfType(List<String> list, FileType fileType) {
        IDocBoss iDocBoss = App.instance().docBoss();
        for (String string : list) {
            IDiffDoc iDiffDoc = iDocBoss.get((Object)string);
            if (iDiffDoc == null || iDiffDoc.fileType() != fileType) continue;
            return iDiffDoc;
        }
        return null;
    }

    public static void openSession(IDiffDoc iDiffDoc, List<String> list, IWorkbenchWindow iWorkbenchWindow) {
        int n = list.size();
        if (iDiffDoc == null || n == 0) {
            return;
        }
        App.instance().viewBoss().viewDoc(iDiffDoc, true);
        list.remove(iDiffDoc.getName());
    }

    /*
     * Unable to fully structure code
     */
    private int findDestinationPort() {
        block11: {
            block10: {
                if (this.foundPort != -1) {
                    if (LaunchAdvisor.LOG.isInfoEnabled()) {
                        LaunchAdvisor.LOG.info("Found port " + this.foundPort);
                    }
                    return this.foundPort;
                }
                var1_1 = LaunchRequestListener.getPortFile();
                if (!var1_1.exists()) {
                    if (LaunchAdvisor.LOG.isInfoEnabled()) {
                        LaunchAdvisor.LOG.info("Port file not found: " + var1_1);
                    }
                    return -1;
                }
                var2_2 = null;
                var2_2 = new BufferedReader(new FileReader(var1_1));
                var3_3 = StringUtil.makeSafe((String)var2_2.readLine()).trim();
                if (var3_3.length() <= 0) ** GOTO lbl29
                var4_5 = Integer.parseInt(var3_3);
                if (!this.isServerAlive(var4_5)) break block10;
                this.foundPort = var4_5;
                if (LaunchAdvisor.LOG.isInfoEnabled()) {
                    LaunchAdvisor.LOG.info("App found on port: " + var4_5);
                }
                var6_6 = var4_5;
                StreamUtil.closeSilently((Closeable)var2_2);
                return var6_6;
            }
            try {
                try {
                    if (!LaunchAdvisor.LOG.isInfoEnabled()) break block11;
                    LaunchAdvisor.LOG.info("No app found on port: " + var4_5);
                    break block11;
lbl29:
                    // 1 sources

                    LaunchAdvisor.LOG.warn("No data in port file: " + var1_1);
                }
                catch (IOException | NumberFormatException var3_4) {
                    LaunchAdvisor.LOG.warn("Failed to read port file: " + var1_1, (Throwable)var3_4);
                    StreamUtil.closeSilently((Closeable)var2_2);
                }
            }
            catch (Throwable var5_7) {
                StreamUtil.closeSilently(var2_2);
                throw var5_7;
            }
        }
        StreamUtil.closeSilently((Closeable)var2_2);
        var1_1.delete();
        return -1;
    }

    public boolean isDeltaWalkerRunning() {
        return this.findDestinationPort() != -1;
    }

    private boolean isServerAlive(int n) {
        try {
            String string;
            Socket socket = new Socket("localhost", n);
            try {
                PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    try {
                        printWriter.println("Hi, DeltaWalker, how are you doing?");
                        string = StringUtil.makeSafe((String)bufferedReader.readLine());
                    }
                    finally {
                        StreamUtil.closeSilently((Closeable)bufferedReader);
                    }
                }
                finally {
                    StreamUtil.closeSilently((Closeable)printWriter);
                }
            }
            finally {
                StreamUtil.closeSilently((Closeable)socket);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Read app response: " + string);
            }
            return string.equals("Doing well, thank you.");
        }
        catch (ConnectException connectException) {
            LOG.warn("Cannot connect to app on port " + n + ": " + connectException.getMessage());
        }
        catch (IOException iOException) {
            LOG.warn("Failed to communicate with app on port " + n, (Throwable)iOException);
        }
        return false;
    }

    private void sendLaunchArguments(int n, List<String> list) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Send launch arguments on port " + n + ": " + list);
        }
        try {
            Socket socket = new Socket("localhost", n);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            if (list.isEmpty()) {
                printWriter.println("ACTIVATE_APP_ON_FRONT");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string : list) {
                    if (StringUtil.isEmpty((String)string)) continue;
                    stringBuffer.append(string);
                    stringBuffer.append(":;:");
                }
                printWriter.println(stringBuffer);
            }
            printWriter.close();
            socket.close();
        }
        catch (IOException iOException) {
            LOG.error(null, (Throwable)iOException);
        }
    }

    public void sendLaunchArguments(List<String> list) {
        int n = this.findDestinationPort();
        if (n != -1) {
            this.sendLaunchArguments(n, list);
        } else {
            LOG.warn("No destination port");
        }
    }

    public void startLaunchRequestListener() {
        try {
            this.launchServer = new LaunchRequestListener();
            this.launchServer.start();
        }
        catch (IOException iOException) {
            LOG.warn("Cannot start launch server", (Throwable)iOException);
        }
    }

    public void stopLaunchRequestListener() {
        if (this.launchServer != null && this.launchServer.isAlive()) {
            this.launchServer.stopListening();
            this.launchServer = null;
        }
    }
}

