/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.App;
import com.deltawalker.interfaces.IStateBoss;
import com.deltawalker.product.application.internal.ApplicationProductPlugin;
import com.deltawalker.ui.AppWindowLayout;
import com.deltawalker.ui.UIUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWPerspective
implements IPerspectiveFactory {
    private static final float DEF_COMPARE_VIEW_RATIO = 0.4f;
    private static final float DEF_CONSOLE_VIEW_RATIO = 0.75f;
    public static final String ID = String.valueOf(ApplicationProductPlugin.getPluginId()) + ".deltaWalkerPerspective";
    private static final Logger LOG = LoggerFactory.getLogger(DWPerspective.class);

    private void calculatePositionAndRatio(Rectangle rectangle, Rectangle rectangle2, int[] nArray, float[] fArray) {
        boolean bl;
        float f = rectangle.width;
        float f2 = rectangle.height;
        int n = rectangle2.width;
        int n2 = rectangle2.height;
        boolean bl2 = bl = rectangle.width > rectangle.height;
        if (rectangle.x == 0 && rectangle.y == 0) {
            nArray[0] = bl ? 3 : 1;
            fArray[0] = bl ? f2 / (float)n2 : f / (float)n;
        } else if (rectangle.x > 0 && rectangle.y > 0) {
            nArray[0] = 2;
            fArray[0] = 1.0f - f / (float)rectangle2.width;
        } else if (rectangle.x > 0 || rectangle.y > 0) {
            nArray[0] = bl ? 4 : 2;
            fArray[0] = bl ? 1.0f - f2 / (float)n2 : 1.0f - f / (float)n;
        }
    }

    public void createInitialLayout(IPageLayout iPageLayout) {
        IPlaceholderFolderLayout iPlaceholderFolderLayout;
        String string = iPageLayout.getEditorArea();
        IStateBoss iStateBoss = App.instance().stateBoss();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)UIUtil.getActiveWindow();
        if (PlatformUI.getWorkbench().getWorkbenchWindowCount() <= 1) {
            iStateBoss.loadState((IWorkbenchWindow)workbenchWindow);
        }
        AppWindowLayout appWindowLayout = iStateBoss.appWindowLayout();
        int[] nArray = new int[]{3};
        float[] fArray = new float[]{0.4f};
        int[] nArray2 = new int[]{4};
        float[] fArray2 = new float[]{0.75f};
        Rectangle rectangle = appWindowLayout.getAppWindowBounds();
        if (!rectangle.isEmpty()) {
            Rectangle rectangle2;
            this.loadWindowState(appWindowLayout);
            LOG.info("rcWnd=" + rectangle);
            iPlaceholderFolderLayout = workbenchWindow.getPageComposite().getClientArea();
            LOG.info("rcClient=" + iPlaceholderFolderLayout);
            Rectangle rectangle3 = appWindowLayout.getCompareViewBounds();
            if (!rectangle3.isEmpty()) {
                LOG.info("COMPARE_VIEW bounds=" + rectangle3);
                if (!rectangle3.equals((Object)iPlaceholderFolderLayout)) {
                    this.calculatePositionAndRatio(rectangle3, (Rectangle)iPlaceholderFolderLayout, nArray, fArray);
                }
                LOG.info("ratioCmpView=" + fArray[0] + "   posCompView=" + nArray[0]);
            }
            if (!(rectangle2 = appWindowLayout.getConsoleViewBounds()).isEmpty()) {
                LOG.info("CONSOLE_VIEW bounds=" + rectangle2);
                this.calculatePositionAndRatio(rectangle2, (Rectangle)iPlaceholderFolderLayout, nArray2, fArray2);
                LOG.info("ratioConView=" + fArray2 + "   posConView=" + nArray2);
            }
        }
        iPlaceholderFolderLayout = iPageLayout.createPlaceholderFolder(UIUtil.COMPARE_VIEW_ID, nArray[0], fArray[0], string);
        iPlaceholderFolderLayout.addPlaceholder(String.valueOf(UIUtil.COMPARE_VIEW_ID) + ":*");
        iPlaceholderFolderLayout = iPageLayout.createPlaceholderFolder("org.eclipse.ui.console.ConsoleView", nArray2[0], fArray2[0], string);
    }

    public void loadWindowState(final AppWindowLayout appWindowLayout) {
        StartupThreading.runWithoutExceptions((StartupThreading.StartupRunnable)new StartupThreading.StartupRunnable(){

            public void runWithException() {
                Rectangle rectangle;
                IWorkbenchWindow iWorkbenchWindow = UIUtil.getActiveWindow();
                Display display = iWorkbenchWindow.getShell().getDisplay();
                Rectangle rectangle2 = display.getBounds();
                Rectangle rectangle3 = appWindowLayout.getAppWindowBounds();
                if (!rectangle3.intersects(rectangle2)) {
                    rectangle = display.getClientArea();
                    rectangle3.x = rectangle.x;
                    rectangle3.y = rectangle.y;
                }
                rectangle = iWorkbenchWindow.getShell();
                rectangle.setBounds(rectangle3);
            }
        });
    }
}

