/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.Addon;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.product.application.internal.Application;
import com.deltawalker.product.application.internal.ApplicationActionBarAdvisor;
import com.deltawalker.product.application.internal.LaunchAdvisor;
import com.deltawalker.product.application.internal.Msg;
import com.deltawalker.ui.AppWindowLayout;
import com.deltawalker.ui.CompareEditor;
import com.deltawalker.ui.CompareView;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.FileDnDProcessor;
import com.deltawalker.ui.TrayItemHelper;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.io.FileInfo;
import com.deltopia.jface.util.StatusLineUtil;
import com.deltopia.ui.dnd.IFileDropTarget;
import com.deltopia.util.OS;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements IFileDropTarget {
    private static final String[] ACTION_SETS = new String[]{"org.eclipse.ui.WorkingSetActionSet", "org.eclipse.ui.WorkingSetModificationActionSet", "org.eclipse.ui.NavigateActionSet", "org.eclipse.ui.actionSet.openFiles", "org.eclipse.ui.edit.text.actionSet.annotationNavigation", "org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo", "org.eclipse.ui.edit.text.actionSet.navigation", "org.eclipse.ui.edit.text.actionSet.presentation", "org.eclipse.search.searchActionSet", "org.eclipse.update.ui.softwareUpdates"};
    private static final boolean[] checkForUpdatesIsRun = new boolean[1];
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.product.application.internal.ApplicationWorkbenchWindowAdvisor");
    private static TrayItem trayItem = null;
    private static boolean USE_SYSTEM_TRAY = false;
    private FileDnDProcessor dndProcessor;
    private IWorkbenchPage lastActivePage;
    private IWorkbenchPart lastActivePart;
    private String lastPartTitle = "";
    private final IPartListener2 onPart = new IPartListener2(){

        private void connectSearchField(IWorkbenchPart iWorkbenchPart, boolean bl) {
            DiffView diffView = (DiffView)iWorkbenchPart.getAdapter(DiffView.class);
            if (diffView != null) {
                diffView.controller().connectSearchField(bl, false);
            }
        }

        private IWorkbenchPage getActivePage() {
            IWorkbenchWindow iWorkbenchWindow = ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow();
            return iWorkbenchWindow != null ? iWorkbenchWindow.getActivePage() : null;
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            App.instance().viewBoss().setActiveWorkbenchPart(iWorkbenchPart);
            this.connectSearchField(iWorkbenchPart, true);
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            App.instance().viewBoss().setActiveWorkbenchPart(iWorkbenchPart);
            this.connectSearchField(iWorkbenchPart, true);
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPage iWorkbenchPage = this.getActivePage();
            if (iWorkbenchPage == null) {
                return;
            }
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            App.instance().viewBoss().partClosed(iWorkbenchPart);
            App.instance().scriptBoss().partClosed(iWorkbenchPart);
            if (iWorkbenchPage.getActivePart() == null) {
                iWorkbenchPage.setEditorAreaVisible(false);
            }
            if (iWorkbenchPage.getActiveEditor() == null && iWorkbenchPage.getActivePart() != null) {
                iWorkbenchPage.setEditorAreaVisible(false);
            }
            if (iWorkbenchPart instanceof ViewIntroAdapterPart) {
                ApplicationWorkbenchWindowAdvisor.this.showUnifiedToolBar(true);
            }
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            this.connectSearchField(iWorkbenchPartReference.getPart(false), false);
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPage iWorkbenchPage = this.getActivePage();
            if (iWorkbenchPage == null) {
                return;
            }
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            ApplicationWorkbenchWindowAdvisor.this.showUnifiedToolBar(!(iWorkbenchPart instanceof ViewIntroAdapterPart));
            if (iWorkbenchPart instanceof IViewPart && iWorkbenchPage.getActiveEditor() == null) {
                iWorkbenchPage.setEditorAreaVisible(false);
                return;
            }
            if (!iWorkbenchPage.isEditorAreaVisible()) {
                iWorkbenchPage.setEditorAreaVisible(true);
            }
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    };
    private final IPropertyListener onPartProp = new IPropertyListener(){

        public void propertyChanged(Object object, int n) {
            if (n == 1 && ApplicationWorkbenchWindowAdvisor.this.lastActivePart != null) {
                String string = ApplicationWorkbenchWindowAdvisor.this.lastActivePart.getTitle();
                if (!ApplicationWorkbenchWindowAdvisor.this.lastPartTitle.equals(string)) {
                    ApplicationWorkbenchWindowAdvisor.this.internalUpdateTitle();
                }
            }
        }
    };

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        super(iWorkbenchWindowConfigurer);
        iWorkbenchWindowConfigurer.configureEditorAreaDropListener((DropTargetListener)new DropTargetAdapter());
    }

    public boolean accepts(FileInfo fileInfo) {
        return true;
    }

    private void activateWindow(IWorkbenchWindow iWorkbenchWindow) {
        Shell shell = iWorkbenchWindow.getShell();
        shell.open();
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
        shell.forceActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginCheckForUpdates(IWorkbenchWindow iWorkbenchWindow) {
        String string;
        if (!PrefUtil.getPrefStore().getBoolean(PrefKey.C_CHECK_FOR_UPDATES.toString())) {
            return;
        }
        Shell shell = iWorkbenchWindow.getShell();
        boolean[] blArray = (boolean[])shell.getData(string = UIUtil.CHECK_FOR_UPDATES_IS_RUN_KEY);
        if (blArray == null) {
            blArray = checkForUpdatesIsRun;
            shell.setData(string, (Object)blArray);
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            if (!blArray[0]) {
                IHandlerService iHandlerService;
                blArray[0] = true;
                IActionCommandMappingService iActionCommandMappingService = (IActionCommandMappingService)iWorkbenchWindow.getService(IActionCommandMappingService.class);
                String string2 = null;
                if (iActionCommandMappingService != null) {
                    string2 = iActionCommandMappingService.getCommandId("com.deltawalker.ui.updates");
                }
                if (string2 == null) {
                    string2 = "com.deltawalker.ui.updates";
                }
                if ((iHandlerService = (IHandlerService)iWorkbenchWindow.getService(IHandlerService.class)) != null) {
                    try {
                        iHandlerService.executeCommand(string2, null);
                    }
                    catch (CommandException commandException) {}
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void checkForUpdates() {
        final IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
        final Shell shell = iWorkbenchWindow.getShell();
        shell.getDisplay().timerExec(20000, new Runnable(){

            @Override
            public void run() {
                if (!shell.isDisposed()) {
                    ApplicationWorkbenchWindowAdvisor.this.beginCheckForUpdates(iWorkbenchWindow);
                }
            }
        });
    }

    private String constructTitle() {
        IWorkbenchPage iWorkbenchPage = this.getWindowConfigurer().getWindow().getActivePage();
        IWorkbenchPart iWorkbenchPart = null;
        if (iWorkbenchPage != null) {
            iWorkbenchPart = iWorkbenchPage.getActivePart();
        }
        String string = "";
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null) {
            string = StringUtil.makeSafe((String)iProduct.getName());
        }
        if (iWorkbenchPage == null || iWorkbenchPart == null || StringUtil.isEmpty((String)iWorkbenchPart.getTitleToolTip())) {
            return string;
        }
        if (iWorkbenchPart instanceof CompareEditor) {
            this.lastPartTitle = ((CompareEditor)iWorkbenchPart).getFullTitle();
        } else if (iWorkbenchPart instanceof CompareView) {
            this.lastPartTitle = ((CompareView)iWorkbenchPart).getFullTitle();
        } else if (iWorkbenchPart instanceof IMvcView) {
            return ((IMvcView)iWorkbenchPart).model().getName();
        }
        return NLS.bind((String)Msg.WorkbenchWindow_shellTitle, (Object)this.lastPartTitle, (Object)string);
    }

    public Control control() {
        return this.getWindowConfigurer().getWindow().getShell();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        return new ApplicationActionBarAdvisor(iActionBarConfigurer);
    }

    public void dispose() {
        if (trayItem != null && PlatformUI.getWorkbench().getWorkbenchWindowCount() < 2) {
            trayItem.dispose();
        }
    }

    public void dropped(DropTargetEvent dropTargetEvent) {
        List list = this.dndProcessor.getDroppedFiles(dropTargetEvent);
        if (!list.isEmpty()) {
            Map map = FileDnDProcessor.uriInfosFromFiles((List)list);
            App.instance().viewBoss().createDocView(map, null, null, false, null, true, true);
        }
    }

    public DropTargetListener dropTargetListener() {
        return this.dndProcessor.dropTargetListener();
    }

    private void installTitleUpdateListeners(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowConfigurer.getWindow();
        iWorkbenchWindow.addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage iWorkbenchPage) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageClosed(IWorkbenchPage iWorkbenchPage) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageOpened(IWorkbenchPage iWorkbenchPage) {
            }
        });
        iWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveDeactivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveSavedAs(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }
        });
        iWorkbenchWindow.getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        });
    }

    private void installTrayItem(final IWorkbenchWindow iWorkbenchWindow) {
        if (!USE_SYSTEM_TRAY || trayItem != null) {
            return;
        }
        final Shell shell = iWorkbenchWindow.getShell();
        trayItem = TrayItemHelper.createTrayItem((Widget)shell);
        if (trayItem != null) {
            trayItem.setToolTipText("DeltaWalker");
            final Action action = new Action(){

                public String getText() {
                    return "Open DeltaWalker";
                }

                public void run() {
                    ApplicationWorkbenchWindowAdvisor.this.activateWindow(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
            };
            trayItem.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    action.run();
                }
            });
            trayItem.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    MenuManager menuManager = new MenuManager();
                    Menu menu = menuManager.createContextMenu((Control)shell);
                    menuManager.add((IAction)action);
                    menuManager.add((IAction)ActionFactory.QUIT.create(iWorkbenchWindow));
                    menu.setVisible(true);
                }
            });
        }
    }

    private void internalUpdateTitle() {
        IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer = this.getWindowConfigurer();
        String string = iWorkbenchWindowConfigurer.getTitle();
        String string2 = this.constructTitle();
        if (!string2.equals(string)) {
            iWorkbenchWindowConfigurer.setTitle(string2);
        }
    }

    public void openIntro() {
        IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
        if (LaunchAdvisor.closeIntro(Application.getResourceArgs(), iWorkbenchWindow)) {
            return;
        }
        String string = Application.getScriptArg();
        if (!string.isEmpty() && LaunchAdvisor.closeIntro(iWorkbenchWindow)) {
            return;
        }
        if (OS.LINUX && OS.OS_VERSION == 3.11 && LaunchAdvisor.closeIntro(iWorkbenchWindow)) {
            return;
        }
        super.openIntro();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null && iWorkbenchPage.findView("org.eclipse.ui.internal.introview") != null) {
            this.showUnifiedToolBar(false);
        }
    }

    public void postWindowCreate() {
        Monitor[] monitorArray;
        IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
        iWorkbenchWindow.getShell().forceActive();
        this.dndProcessor = new FileDnDProcessor((IFileDropTarget)this);
        UIUtil.getSearchToolBarManager((IWorkbenchWindow)iWorkbenchWindow);
        Shell shell = iWorkbenchWindow.getShell();
        Point point = shell.getLocation();
        int n = OS.OSX ? 20 : (shell.getBounds().height - shell.getClientArea().height) / 2;
        point.x += n;
        point.y += n;
        Display display = shell.getDisplay();
        Point point2 = shell.getSize();
        Monitor[] monitorArray2 = monitorArray = display.getMonitors();
        int n2 = monitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Monitor monitor = monitorArray2[n3];
            if (monitor.getBounds().contains(point)) {
                Rectangle rectangle = monitor.getClientArea();
                if (Math.max(point.x, rectangle.x) <= rectangle.x + rectangle.width - point2.x && Math.max(point.y, rectangle.y) <= rectangle.y + rectangle.height - point2.y) break;
                point.x = rectangle.x + n;
                point.y = rectangle.y + n;
                break;
            }
            ++n3;
        }
        shell.setLocation(point);
    }

    public void postWindowOpen() {
        try {
            Object object;
            super.postWindowOpen();
            IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
            final Shell shell = iWorkbenchWindow.getShell();
            final AppWindowLayout appWindowLayout = App.instance().stateBoss().appWindowLayout();
            if (appWindowLayout.maximized) {
                shell.setMaximized(true);
            }
            if (appWindowLayout.minimized) {
                shell.setMinimized(true);
            }
            if (appWindowLayout.fullScreen) {
                shell.setFullScreen(true);
            }
            shell.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent controlEvent) {
                    if (!(shell.getMaximized() || shell.getMinimized() || shell.getFullScreen())) {
                        appWindowLayout.setAppWindowBounds(shell.getBounds());
                    }
                }

                public void controlResized(ControlEvent controlEvent) {
                    this.controlMoved(controlEvent);
                }
            });
            this.installTrayItem(iWorkbenchWindow);
            iWorkbenchWindow.getActivePage().addPartListener(this.onPart);
            if (iWorkbenchWindow != PlatformUI.getWorkbench().getActiveWorkbenchWindow()) {
                this.activateWindow(iWorkbenchWindow);
            }
            String string = Application.getScriptArg();
            Addon.Edition edition = AddonInfoUtil.addonInfo().edition();
            if (!string.isEmpty() && edition != Addon.Edition.STANDARD) {
                object = App.instance().scriptBoss().openScript(string, true);
                object.runScript();
            } else {
                object = Application.getResourceArgs();
                Application.getInstance().openResources((List<String>)object);
            }
            this.raiseTheBar();
            this.showRemainingTrialDays();
            shell.forceActive();
            object = (ApplicationActionBarAdvisor)UIUtil.actionAdvisor();
            if (object != null) {
                ((ApplicationActionBarAdvisor)((Object)object)).updateActions();
            }
            this.checkForUpdates();
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't post-open main window: ", throwable);
        }
    }

    public void preWindowOpen() {
        try {
            super.preWindowOpen();
            IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer = this.getWindowConfigurer();
            iWorkbenchWindowConfigurer.setShowProgressIndicator(false);
            iWorkbenchWindowConfigurer.setShowPerspectiveBar(!OS.COCOA);
            this.installTitleUpdateListeners(iWorkbenchWindowConfigurer);
            this.removeActions();
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't pre-open main window: ", throwable);
        }
    }

    public boolean preWindowShellClose() {
        IWorkbenchPage[] iWorkbenchPageArray;
        IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
        App.instance().stateBoss().saveState();
        iWorkbenchWindow.getActivePage().removePartListener(this.onPart);
        if (!App.instance().docBoss().saveEditors(iWorkbenchWindow)) {
            return false;
        }
        if (USE_SYSTEM_TRAY && PlatformUI.getWorkbench().getWorkbenchWindowCount() < 2) {
            iWorkbenchWindow.getShell().setVisible(false);
            return false;
        }
        IWorkbenchPage[] iWorkbenchPageArray2 = iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray2[n2];
            iWorkbenchPage.closeAllEditors(false);
            ++n2;
        }
        return true;
    }

    private void raiseTheBar() {
        final Display display = this.getWindowConfigurer().getWindow().getShell().getDisplay();
        final Runnable[] runnableArray = new Runnable[1];
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                display.timerExec(28999, runnableArray[0]);
            }
        };
        runnableArray[0] = new Runnable(){

            @Override
            public void run() {
                if (!AddonInfoUtil.validate()) {
                    Application.getInstance().stop();
                    return;
                }
                if (AddonInfoUtil.addonInfo().edition() == Addon.Edition.TRIAL) {
                    display.timerExec(289990, runnableArray[0]);
                } else {
                    display.removeFilter(1, listener);
                    display.removeFilter(5, listener);
                }
            }
        };
        display.addFilter(1, listener);
        display.addFilter(5, listener);
        display.timerExec(28999, runnableArray[0]);
    }

    private void removeActions() {
        IActionSetDescriptor[] iActionSetDescriptorArray;
        ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] iActionSetDescriptorArray2 = iActionSetDescriptorArray = actionSetRegistry.getActionSets();
        int n = iActionSetDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor iActionSetDescriptor = iActionSetDescriptorArray2[n2];
            String[] stringArray = ACTION_SETS;
            int n3 = ACTION_SETS.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                if (iActionSetDescriptor.getId().equals(string)) {
                    IExtension iExtension = iActionSetDescriptor.getConfigurationElement().getDeclaringExtension();
                    actionSetRegistry.removeExtension(iExtension, new Object[]{iActionSetDescriptor});
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void showRemainingTrialDays() {
        int n = AddonInfoUtil.remainingDays();
        if (n >= 0) {
            StatusLineUtil.setTimedMessage((IStatusLineManager)this.getWindowConfigurer().getActionBarConfigurer().getStatusLineManager(), (String)AddonInfoUtil.constructReminderMessage());
        }
    }

    public void showUnifiedToolBar(boolean bl) {
        if (OS.COCOA) {
            ((ApplicationWindow)this.getWindowConfigurer().getWindow()).getToolBarManager().getControl().setVisible(bl);
        }
    }

    private void updateTitle() {
        IWorkbenchPage iWorkbenchPage = this.getWindowConfigurer().getWindow().getActivePage();
        IWorkbenchPart iWorkbenchPart = null;
        if (iWorkbenchPage != null) {
            iWorkbenchPart = iWorkbenchPage.getActivePart();
        }
        if (iWorkbenchPart == this.lastActivePart && iWorkbenchPage == this.lastActivePage) {
            return;
        }
        if (this.lastActivePart != null) {
            this.lastActivePart.removePropertyListener(this.onPartProp);
        }
        this.lastActivePart = iWorkbenchPart;
        this.lastActivePage = iWorkbenchPage;
        if (iWorkbenchPart != null) {
            iWorkbenchPart.addPropertyListener(this.onPartProp);
        }
        this.internalUpdateTitle();
    }
}

