/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.interfaces.IExceptionHandler;
import com.deltawalker.product.application.internal.AbstractStatusHandlerProxy;
import com.deltawalker.product.application.internal.ApplicationWorkbenchWindowAdvisor;
import com.deltawalker.product.application.internal.DWPerspective;
import com.deltawalker.ui.UIUtil;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final ApplicationWorkbenchAdvisor instance = new ApplicationWorkbenchAdvisor();
    private AbstractStatusHandler errHandler;
    private final IExceptionHandler exHandler = new IExceptionHandler(){

        public boolean handleException(Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                UIUtil.showOutOfMemoryError();
                return true;
            }
            return false;
        }
    };

    static {
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                IExceptionHandler iExceptionHandler = ApplicationWorkbenchAdvisor.getInstance().getExceptionHandler();
                if (!(iExceptionHandler != null && iExceptionHandler.handleException(throwable) || uncaughtExceptionHandler == null)) {
                    uncaughtExceptionHandler.uncaughtException(thread, throwable);
                }
            }
        });
    }

    public static ApplicationWorkbenchAdvisor getInstance() {
        return instance;
    }

    protected ApplicationWorkbenchAdvisor() {
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return new ApplicationWorkbenchWindowAdvisor(iWorkbenchWindowConfigurer);
    }

    public void eventLoopException(Throwable throwable) {
        IExceptionHandler iExceptionHandler = this.getExceptionHandler();
        if (iExceptionHandler == null || !iExceptionHandler.handleException(throwable)) {
            super.eventLoopException(throwable);
        }
    }

    public IExceptionHandler getExceptionHandler() {
        return this.exHandler;
    }

    public String getInitialWindowPerspectiveId() {
        return DWPerspective.ID;
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        AbstractStatusHandler abstractStatusHandler;
        if (this.errHandler == null && (abstractStatusHandler = super.getWorkbenchErrorHandler()) != null) {
            this.errHandler = new AbstractStatusHandlerProxy(abstractStatusHandler){

                @Override
                public void handle(StatusAdapter statusAdapter, int n) {
                    IExceptionHandler iExceptionHandler = ApplicationWorkbenchAdvisor.this.getExceptionHandler();
                    Throwable throwable = statusAdapter.getStatus().getException();
                    if (iExceptionHandler == null || !iExceptionHandler.handleException(throwable)) {
                        super.handle(statusAdapter, n);
                    }
                }
            };
        }
        return this.errHandler;
    }

    public void initialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
        super.initialize(iWorkbenchConfigurer);
        iWorkbenchConfigurer.setSaveAndRestore(false);
    }
}

