/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.product.application.internal;

import com.deltawalker.AddonInfoUtil;
import com.deltawalker.App;
import com.deltawalker.IPersistable;
import com.deltawalker.Pre;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.StateBoss;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.interfaces.IScriptDoc;
import com.deltawalker.interfaces.IStateBoss;
import com.deltawalker.interfaces.IViewBoss;
import com.deltawalker.product.application.internal.ApplicationWorkbenchAdvisor;
import com.deltawalker.product.application.internal.LaunchAdvisor;
import com.deltawalker.script.Role;
import com.deltawalker.ui.AppWindowLayout;
import com.deltawalker.ui.MenuCombo;
import com.deltawalker.ui.UIUtil;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.ui.swt.Win32MouseWheelFilter;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
implements IApplication {
    public static final String ARG_MERGED = "-merged=";
    private static final String ARG_MI = "-mi";
    public static final String ARG_NO_MRU = "-nomru";
    private static final String ARG_PWD = "-pwd=";
    public static final String ARG_SCRIPT = "-script=";
    private static final String ARG_SHOW_LOCATION = "-showlocation";
    public static final String ARG_TITLE_0 = "-title0=";
    public static final String ARG_TITLE_1 = "-title1=";
    public static final String ARG_TITLE_2 = "-title2=";
    private static final int ASFW_ANY = -1;
    private static Application instance;
    private static final Logger LOG;
    private static boolean noMru;
    private LaunchAdvisor launchAdvisor;

    static {
        LOG = LoggerFactory.getLogger(Application.class);
    }

    public static String _getArgValue(String string, String string2) {
        int n = string.indexOf(string2) + string2.length();
        if (n != -1) {
            int n2;
            int n3;
            int n4 = string.indexOf(34);
            boolean bl = n4 != -1 & n4 <= n + 2;
            int n5 = string.length();
            int n6 = n5 = string.charAt(n5 - 1) == '\n' ? n5 - 1 : n5;
            if (bl) {
                n3 = n4 + 1;
                n2 = string.indexOf(34, n3);
                assert (n2 < n5) : "Missing closing quotes.";
            } else {
                n3 = n;
                int n7 = string.indexOf(" ", n + 1);
                n2 = n7 != -1 ? n7 : n5;
            }
            return n2 > n3 ? string.substring(n3, n2) : "";
        }
        return null;
    }

    private static String[] getAppArgs() {
        String[] stringArray = Platform.getApplicationArgs();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (!OS.OSX || string.length() != ARG_SHOW_LOCATION.length() || !string.equalsIgnoreCase(ARG_SHOW_LOCATION)) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getArgValue(String string, String string2) {
        assert (string.toLowerCase().startsWith(string2));
        String string3 = string.substring(string2.length(), string.length());
        return string3;
    }

    public static Application getInstance() {
        return instance;
    }

    public static UriInfo getMergedArg() {
        String[] stringArray;
        String[] stringArray2 = stringArray = Application.getAppArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.toLowerCase().startsWith(ARG_MERGED)) {
                String string2 = Application.getArgValue(string, ARG_MERGED);
                string2 = FileUtil.resolvePath((String)string2, (String)Application.getPwdArg());
                return new UriInfo(string2, FileType.FILE);
            }
            ++n2;
        }
        return null;
    }

    public static String getPwdArg() {
        String[] stringArray;
        String[] stringArray2 = stringArray = Application.getAppArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.toLowerCase().startsWith(ARG_PWD)) {
                return Application.getArgValue(string, ARG_PWD);
            }
            ++n2;
        }
        return "";
    }

    public static List<String> getResourceArgs() {
        return Application.getResourceArgs(Application.getAppArgs(), false);
    }

    private static List<String> getResourceArgs(String[] stringArray, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = stringArray2[n2];
            if (!string2.isEmpty() && !(string = string2.toLowerCase()).equals(ARG_MI)) {
                if (string.equals(ARG_NO_MRU)) {
                    noMru = true;
                } else if (!(!bl && string.startsWith(ARG_MERGED) || string.startsWith(ARG_PWD) || string.startsWith(ARG_TITLE_1) || string.startsWith(ARG_TITLE_2) || string.startsWith(ARG_TITLE_0) || string.startsWith(ARG_SCRIPT))) {
                    string2 = FileUtil.resolvePath((String)string2, (String)Application.getPwdArg());
                    linkedList.add(string2);
                }
            }
            ++n2;
        }
        return linkedList;
    }

    public static String getScriptArg() {
        String[] stringArray;
        String[] stringArray2 = stringArray = Application.getAppArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.toLowerCase().startsWith(ARG_SCRIPT)) {
                return Application.getArgValue(string, ARG_SCRIPT);
            }
            ++n2;
        }
        return "";
    }

    public static String[] getTitleArgs() {
        String[] stringArray = Application.getAppArgs();
        String[] stringArray2 = new String[Role.count()];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toLowerCase();
            if (string.startsWith(ARG_TITLE_1)) {
                stringArray2[Role.ONE.toInt()] = Application.getArgValue(string, ARG_TITLE_1);
            } else if (string.startsWith(ARG_TITLE_2)) {
                stringArray2[Role.TWO.toInt()] = Application.getArgValue(string, ARG_TITLE_2);
            } else if (string.startsWith(ARG_TITLE_0)) {
                stringArray2[Role.REF.toInt()] = Application.getArgValue(string, ARG_TITLE_0);
            }
            ++n;
        }
        return stringArray2;
    }

    static boolean hasArg(String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.length() == string.length() && string.toLowerCase().equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void installStateMaskFix(Display display) {
        Listener listener = new Listener(){
            private int modifier;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (KeyUtil.hasKey((Event)event, (int)SWT.MOD1) || KeyUtil.hasMask((Event)event, (int)SWT.MOD1)) {
                            this.modifier |= SWT.MOD1;
                        }
                        if (KeyUtil.hasKey((Event)event, (int)SWT.MOD2) || KeyUtil.hasMask((Event)event, (int)SWT.MOD2)) {
                            this.modifier |= SWT.MOD2;
                        }
                        if (!KeyUtil.hasKey((Event)event, (int)SWT.MOD3) && !KeyUtil.hasMask((Event)event, (int)SWT.MOD3)) break;
                        this.modifier |= SWT.MOD3;
                        break;
                    }
                    case 2: {
                        if (event.keyCode == SWT.MOD1 || !KeyUtil.hasMask((Event)event, (int)SWT.MOD1)) {
                            this.modifier &= ~SWT.MOD1;
                        }
                        if (event.keyCode == SWT.MOD2 || !KeyUtil.hasMask((Event)event, (int)SWT.MOD2)) {
                            this.modifier &= ~SWT.MOD2;
                        }
                        if (event.keyCode != SWT.MOD3 && KeyUtil.hasMask((Event)event, (int)SWT.MOD3)) break;
                        this.modifier &= ~SWT.MOD3;
                        break;
                    }
                    case 13: {
                        if (event.widget instanceof MenuCombo) {
                            if (!KeyUtil.hasMask((int)this.modifier, (int)SWT.MOD1) && !KeyUtil.hasMask((Event)event, (int)SWT.MOD1)) break;
                            KeyUtil.setModifier((Widget)event.widget, (int)SWT.MOD1);
                            break;
                        }
                        if (!(event.widget instanceof ToolItem) && !(event.widget instanceof MenuItem) || !KeyUtil.hasMask((int)this.modifier, (int)SWT.MOD1) && !KeyUtil.hasMask((int)this.modifier, (int)SWT.MOD2) && !KeyUtil.hasMask((int)this.modifier, (int)(SWT.MOD1 | SWT.MOD2))) break;
                        KeyUtil.setModifier((Widget)event.widget, (int)this.modifier);
                    }
                }
            }
        };
        display.addFilter(1, listener);
        display.addFilter(2, listener);
        display.addFilter(13, listener);
    }

    public Application() {
        instance = this;
    }

    void openResources(List<String> list) {
        Map map;
        IDiffDoc iDiffDoc;
        IApp iApp = App.instance();
        boolean bl = PlatformUI.getWorkbench().getWorkbenchWindowCount() > 1;
        IWorkbenchWindow iWorkbenchWindow = UIUtil.getActiveWindow();
        IDiffDoc iDiffDoc2 = LaunchAdvisor.getSessionOfType(list, FileType.FOLDER);
        if (iDiffDoc2 != null) {
            LaunchAdvisor.openSession(iDiffDoc2, list, iWorkbenchWindow);
        }
        if ((iDiffDoc = LaunchAdvisor.getSessionOfType(list, FileType.FILE)) != null) {
            LaunchAdvisor.openSession(iDiffDoc2, list, iWorkbenchWindow);
        }
        if (iDiffDoc != null || iDiffDoc2 != null) {
            return;
        }
        Map map2 = map = bl ? Collections.emptyMap() : UriInfo.processCmdLineArgs(list);
        if (LOG.isInfoEnabled()) {
            LOG.info("Opening command line resources: ");
            UriInfoUtil.log((Map)map);
        }
        IViewBoss iViewBoss = iApp.viewBoss();
        if (!map.isEmpty()) {
            UriInfoUtil.addTitles((Map)map, (String[])Application.getTitleArgs());
            iViewBoss.createDocView(map, null, null, false, Application.getMergedArg(), false, true);
        } else {
            IStateBoss iStateBoss;
            Object object;
            boolean bl2;
            boolean bl3 = bl2 = !bl && PrefUtil.getPrefStore().getBoolean(PrefKey.C_LAUNCH_MRU.toString()) && !noMru;
            if (bl2) {
                IDiffDoc iDiffDoc32;
                IDocBoss iDocBoss = iApp.docBoss();
                NavigableSet navigableSet = iDocBoss.getAll(FileType.FILE, true).descendingSet();
                for (IDiffDoc iDiffDoc32 : navigableSet) {
                    iApp.viewBoss().viewDoc(iDiffDoc32, false);
                }
                navigableSet = iDocBoss.getAll(FileType.FOLDER, true).descendingSet();
                for (IDiffDoc iDiffDoc32 : navigableSet) {
                    iApp.viewBoss().viewDoc(iDiffDoc32, false);
                }
                iDiffDoc32 = iApp.scriptBoss();
                NavigableSet navigableSet2 = iDiffDoc32.scriptDocs().descendingSet();
                object = navigableSet2.iterator();
                while (object.hasNext()) {
                    iStateBoss = (IScriptDoc)object.next();
                    if (!iStateBoss.getHasOpenView()) continue;
                    ((IPersistable)iStateBoss).doLoad(null, null);
                    iDiffDoc32.viewDoc((IScriptDoc)iStateBoss, false);
                }
            }
            boolean bl4 = UIUtil.getCompareViews((IWorkbenchWindow)iWorkbenchWindow).isEmpty();
            boolean bl5 = UIUtil.getCompareEditors((IWorkbenchWindow)iWorkbenchWindow).isEmpty();
            boolean bl6 = UIUtil.getScriptEditors((IWorkbenchWindow)iWorkbenchWindow).isEmpty();
            boolean bl7 = iWorkbenchWindow.getWorkbench().getIntroManager().getIntro() == null;
            iStateBoss = iApp.stateBoss();
            object = iStateBoss.appWindowLayout();
            if (!object.getAppWindowBounds().isEmpty()) {
                if (bl7 && ((AppWindowLayout)object).hasIntro) {
                    iWorkbenchWindow.getWorkbench().getIntroManager().showIntro(iWorkbenchWindow, false);
                } else {
                    if (bl5 && ((AppWindowLayout)object).hasEmptyCompareEditor) {
                        iApp.viewBoss().openCompareEditor(ContentType.TEXT);
                    }
                    if (bl4 && ((AppWindowLayout)object).hasEmptyCompareView) {
                        iApp.viewBoss().showCompareView(null, null);
                    }
                    if (bl6 && ((AppWindowLayout)object).hasEmptyScriptEditor) {
                        iApp.scriptBoss().openScript(null, false);
                    }
                }
            }
            if (bl4 && bl5 && bl7 && StateBoss.is((Pre)Pre.V_1993)) {
                iApp.viewBoss().openCompareEditor(ContentType.TEXT);
            }
        }
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        String[] stringArray;
        int n;
        this.launchAdvisor = new LaunchAdvisor();
        if (LOG.isInfoEnabled()) {
            String[] stringArray2;
            String[] stringArray3 = stringArray2 = Platform.getApplicationArgs();
            n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                stringArray = stringArray3[n2];
                LOG.info("ARG: " + (String)stringArray);
                ++n2;
            }
        }
        boolean bl = false;
        stringArray = Application.getAppArgs();
        String[] stringArray4 = stringArray;
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String string = stringArray4[n];
            if (string.length() == ARG_MI.length() && string.equals(ARG_MI)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && this.launchAdvisor.isDeltaWalkerRunning()) {
            List<String> list = Application.getResourceArgs(stringArray, true);
            if (LOG.isInfoEnabled()) {
                LOG.info("Application already launched. Pass arguments: " + list);
            }
            this.launchAdvisor.sendLaunchArguments(list);
            return IApplication.EXIT_OK;
        }
        LOG.info("Application is launching");
        Display display = PlatformUI.createDisplay();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                App.instance().stateBoss().saveState();
            }
        };
        display.addListener(21, listener);
        UIUtil.enableDialogHelp();
        try {
            if (!AddonInfoUtil.validate()) {
                Integer n4 = IApplication.EXIT_OK;
                return n4;
            }
            this.launchAdvisor.startLaunchRequestListener();
            Application.installStateMaskFix(display);
            if (OS.WIN) {
                new Win32MouseWheelFilter(display);
            }
            if ((n3 = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)ApplicationWorkbenchAdvisor.getInstance())) == 1) {
                Integer n5 = IApplication.EXIT_RESTART;
                return n5;
            }
            Integer n6 = IApplication.EXIT_OK;
            return n6;
        }
        finally {
            if (!display.isDisposed()) {
                display.removeListener(21, listener);
                display.dispose();
            }
        }
    }

    public void stop() {
        IWorkbench iWorkbench;
        if (this.launchAdvisor != null) {
            this.launchAdvisor.stopLaunchRequestListener();
            this.launchAdvisor = null;
        }
        if ((iWorkbench = PlatformUI.getWorkbench()) == null) {
            return;
        }
        final Display display = iWorkbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    iWorkbench.close();
                }
            }
        });
    }
}

