/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class ResultHelper {
    private static final Logger log = LoggerFactory.getLogger(ResultHelper.class);
    private static final String XML = "http://www.w3.org/XML/1998/namespace";
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final boolean NEEDS_XMLNS_ATTRIBUTES = ResultHelper.needsXmlnsAttributes();

    private static boolean needsXmlnsAttributes() {
        try {
            StringWriter stringWriter = new StringWriter();
            TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
            transformerHandler.setResult(new StreamResult(stringWriter));
            transformerHandler.startDocument();
            transformerHandler.startPrefixMapping("p", "uri");
            transformerHandler.startElement("uri", "e", "p:e", new AttributesImpl());
            transformerHandler.endElement("uri", "e", "p:e");
            transformerHandler.endPrefixMapping("p");
            transformerHandler.endDocument();
            return stringWriter.toString().indexOf("xmlns") == -1;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("XML serialization fails");
        }
    }

    public static Result getResult(Result result) throws SAXException {
        try {
            TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
            transformerHandler.setResult(result);
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            if (NEEDS_XMLNS_ATTRIBUTES) {
                return new SAXResult(new SerializingContentHandler(transformerHandler));
            }
            return result;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException("Failed to initialize XML serializer", transformerConfigurationException);
        }
    }

    private ResultHelper() {
    }

    private static final class SerializingContentHandler
    extends DefaultHandler {
        private List prefixList = new ArrayList();
        private List uriList = new ArrayList();
        private Map uriToPrefixMap = new HashMap();
        private Map prefixToUriMap = new HashMap();
        private boolean hasMappings = false;
        private final List addedPrefixMappings = new ArrayList();
        private final ContentHandler handler;

        private SerializingContentHandler(ContentHandler contentHandler) {
            this.handler = contentHandler;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.handler.characters(cArray, n, n2);
        }

        @Override
        public void startDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.handler.startDocument();
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            if (string2 != null && !string.startsWith("xml")) {
                this.hasMappings = true;
                this.prefixList.add(string);
                this.uriList.add(string2);
                if (string.length() > 0) {
                    this.uriToPrefixMap.put(string2, String.valueOf(string) + ":");
                } else {
                    this.uriToPrefixMap.put(string2, string);
                }
                this.prefixToUriMap.put(string, string2);
            }
            this.handler.startPrefixMapping(string, string2);
        }

        private void checkPrefixMapping(String string, String string2) throws SAXException {
            if (string != null && string.length() > 0 && !string.startsWith("xml") && !this.uriToPrefixMap.containsKey(string)) {
                int n;
                String string3 = "ns";
                if (string2 != null && string2.length() > 0 && (n = string2.indexOf(58)) != -1) {
                    string3 = string2.substring(0, n);
                }
                String string4 = string3;
                int n2 = 2;
                while (this.prefixToUriMap.containsKey(string3)) {
                    string3 = String.valueOf(string4) + n2;
                    ++n2;
                }
                n2 = this.addedPrefixMappings.size() - 1;
                ArrayList<String> arrayList = (ArrayList<String>)this.addedPrefixMappings.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.addedPrefixMappings.set(n2, arrayList);
                }
                arrayList.add(string3);
                this.startPrefixMapping(string3, string);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.addedPrefixMappings.add(null);
            this.checkPrefixMapping(string, string3);
            int n = 0;
            while (n < attributes.getLength()) {
                this.checkPrefixMapping(attributes.getURI(n), attributes.getQName(n));
                ++n;
            }
            if (string != null && string.length() != 0 && this.uriToPrefixMap.containsKey(string)) {
                string3 = this.uriToPrefixMap.get(string) + string2;
            }
            if (this.hasMappings) {
                AttributesImpl attributesImpl = null;
                int n2 = this.prefixList.size();
                int n3 = attributes.getLength();
                int n4 = 0;
                while (n4 < n2) {
                    String string4 = (String)this.uriList.get(n4);
                    String string5 = (String)this.prefixList.get(n4);
                    String string6 = string5.equals("") ? "xmlns" : "xmlns:" + string5;
                    boolean bl = false;
                    int n5 = 0;
                    while (n5 < n3) {
                        if (string6.equals(attributes.getQName(n5))) {
                            if (!string4.equals(attributes.getValue(n5))) {
                                throw new SAXException("URI in prefix mapping and attribute do not match");
                            }
                            bl = true;
                            break;
                        }
                        ++n5;
                    }
                    if (!bl) {
                        if (attributesImpl == null) {
                            attributesImpl = n3 == 0 ? new AttributesImpl() : new AttributesImpl(attributes);
                        }
                        if (string5.equals("")) {
                            attributesImpl.addAttribute(ResultHelper.XML, string6, string6, "CDATA", string4);
                        } else {
                            attributesImpl.addAttribute(ResultHelper.XML, string5, string6, "CDATA", string4);
                        }
                    }
                    ++n4;
                }
                this.clearMappings();
                this.handler.startElement(string, string2, string3, attributesImpl == null ? attributes : attributesImpl);
            } else {
                this.handler.startElement(string, string2, string3, attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string != null && string.length() != 0 && this.uriToPrefixMap.containsKey(string)) {
                string3 = this.uriToPrefixMap.get(string) + string2;
            }
            this.handler.endElement(string, string2, string3);
            int n = this.addedPrefixMappings.size() - 1;
            List list = (List)this.addedPrefixMappings.remove(n);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.endPrefixMapping((String)iterator.next());
                }
            }
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
            int n;
            if (this.prefixToUriMap.containsKey(string)) {
                this.uriToPrefixMap.remove(this.prefixToUriMap.get(string));
                this.prefixToUriMap.remove(string);
            }
            if (this.hasMappings && (n = this.prefixList.lastIndexOf(string)) != -1) {
                this.prefixList.remove(n);
                this.uriList.remove(n);
            }
            this.handler.endPrefixMapping(string);
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.handler.ignorableWhitespace(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.handler.processingInstruction(string, string2);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.handler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            this.handler.skippedEntity(string);
        }

        @Override
        public void endDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.handler.endDocument();
        }

        private void clearMappings() {
            this.hasMappings = false;
            this.prefixList.clear();
            this.uriList.clear();
        }
    }
}

