/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.xml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespace {
    private static Logger log = LoggerFactory.getLogger(Namespace.class);
    public static final Namespace EMPTY_NAMESPACE = new Namespace("", "");
    public static final Namespace XML_NAMESPACE = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
    public static final Namespace XMLNS_NAMESPACE = new Namespace("xmlns", "http://www.w3.org/2000/xmlns/");
    private final String prefix;
    private final String uri;

    private Namespace(String string, String string2) {
        this.prefix = string;
        this.uri = string2;
    }

    public static Namespace getNamespace(String string, String string2) {
        if (string == null) {
            string = EMPTY_NAMESPACE.getPrefix();
        }
        if (string2 == null) {
            string2 = EMPTY_NAMESPACE.getURI();
        }
        return new Namespace(string, string2);
    }

    public static Namespace getNamespace(String string) {
        return Namespace.getNamespace("", string);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isSame(String string) {
        Namespace namespace = Namespace.getNamespace(string);
        return this.equals(namespace);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Namespace) {
            return this.uri.equals(((Namespace)object).uri);
        }
        return false;
    }
}

