/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.xml;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementIterator
implements Iterator<Element> {
    private static Logger log = LoggerFactory.getLogger(ElementIterator.class);
    private final Namespace namespace;
    private final String localName;
    private final QName qName;
    private Element next;

    public ElementIterator(Element element, String string, Namespace namespace) {
        this.localName = string;
        this.namespace = namespace;
        this.qName = null;
        this.seek(element);
    }

    public ElementIterator(Element element, QName qName) {
        this.localName = null;
        this.namespace = null;
        this.qName = qName;
        this.seek(element);
    }

    public ElementIterator(Element element) {
        this(element, null, null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not implemented.");
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Element next() {
        return this.nextElement();
    }

    public Element nextElement() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Element element = this.next;
        this.seek();
        return element;
    }

    private void seek(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (this.matchesName(node)) {
                this.next = (Element)node;
                return;
            }
            ++n;
        }
    }

    private void seek() {
        Node node = this.next.getNextSibling();
        while (node != null) {
            if (this.matchesName(node)) {
                this.next = (Element)node;
                return;
            }
            node = node.getNextSibling();
        }
        this.next = null;
    }

    private boolean matchesName(Node node) {
        if (!DomUtil.isElement(node)) {
            return false;
        }
        if (this.qName != null) {
            return DomUtil.matches(node, this.qName);
        }
        return DomUtil.matches(node, this.localName, this.namespace);
    }
}

