/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.ResultHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DomUtil {
    private static Logger log = LoggerFactory.getLogger(DomUtil.class);
    private static DocumentBuilderFactory BUILDER_FACTORY = DomUtil.createFactory();
    private static TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    private static DocumentBuilderFactory createFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.warn("Secure XML processing is not supported", (Throwable)parserConfigurationException);
        }
        catch (AbstractMethodError abstractMethodError) {
            log.warn("Secure XML processing is not supported", (Throwable)abstractMethodError);
        }
        return documentBuilderFactory;
    }

    public static void setBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        BUILDER_FACTORY = documentBuilderFactory;
    }

    public static Document createDocument() throws ParserConfigurationException {
        return BUILDER_FACTORY.newDocumentBuilder().newDocument();
    }

    public static Document parseDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = BUILDER_FACTORY.newDocumentBuilder();
        documentBuilder.setErrorHandler(new DefaultHandler());
        return documentBuilder.parse(inputStream);
    }

    public static String getAttribute(Element element, String string, Namespace namespace) {
        if (element == null) {
            return null;
        }
        Attr attr = namespace == null ? element.getAttributeNode(string) : element.getAttributeNodeNS(namespace.getURI(), string);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public static Attr[] getNamespaceAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        ArrayList<Attr> arrayList = new ArrayList<Attr>();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (Namespace.XMLNS_NAMESPACE.getURI().equals(attr.getNamespaceURI())) {
                arrayList.add(attr);
            }
            ++n;
        }
        return arrayList.toArray(new Attr[arrayList.size()]);
    }

    public static String getText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (DomUtil.isText(node)) {
                    stringBuffer.append(((CharacterData)node).getData());
                }
                ++n;
            }
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public static String getText(Element element, String string) {
        String string2 = DomUtil.getText(element);
        return string2 == null ? string : string2;
    }

    public static String getTextTrim(Element element) {
        String string = DomUtil.getText(element);
        return string == null ? string : string.trim();
    }

    public static String getChildText(Element element, String string, Namespace namespace) {
        Element element2 = DomUtil.getChildElement(element, string, namespace);
        return element2 == null ? null : DomUtil.getText(element2);
    }

    public static String getChildTextTrim(Element element, String string, Namespace namespace) {
        Element element2 = DomUtil.getChildElement(element, string, namespace);
        return element2 == null ? null : DomUtil.getTextTrim(element2);
    }

    public static String getChildTextTrim(Element element, QName qName) {
        Element element2 = DomUtil.getChildElement(element, qName);
        return element2 == null ? null : DomUtil.getTextTrim(element2);
    }

    public static boolean hasChildElement(Node node, String string, Namespace namespace) {
        return DomUtil.getChildElement(node, string, namespace) != null;
    }

    public static Element getChildElement(Node node, String string, Namespace namespace) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (DomUtil.isElement(node2) && DomUtil.matches(node2, string, namespace)) {
                    return (Element)node2;
                }
                ++n;
            }
        }
        return null;
    }

    public static Element getChildElement(Node node, QName qName) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (DomUtil.isElement(node2) && DomUtil.matches(node2, qName)) {
                    return (Element)node2;
                }
                ++n;
            }
        }
        return null;
    }

    public static ElementIterator getChildren(Element element, String string, Namespace namespace) {
        return new ElementIterator(element, string, namespace);
    }

    public static ElementIterator getChildren(Element element, QName qName) {
        return new ElementIterator(element, qName);
    }

    public static ElementIterator getChildren(Element element) {
        return new ElementIterator(element);
    }

    public static Element getFirstChildElement(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (DomUtil.isElement(node2)) {
                    return (Element)node2;
                }
                ++n;
            }
        }
        return null;
    }

    public static boolean hasContent(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (DomUtil.isAcceptedNode(node2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static List<Node> getContent(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (DomUtil.isAcceptedNode(node2)) {
                    arrayList.add(node2);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static Namespace getNamespace(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getPrefix();
        if (string == null) {
            return Namespace.EMPTY_NAMESPACE;
        }
        return Namespace.getNamespace(string2, string);
    }

    public static boolean matches(Node node, String string, Namespace namespace) {
        if (node == null) {
            return false;
        }
        boolean bl = DomUtil.matchingNamespace(node, namespace);
        return bl && DomUtil.matchingLocalName(node, string);
    }

    public static boolean matches(Node node, QName qName) {
        String string;
        if (node == null) {
            return false;
        }
        String string2 = string = node.getNamespaceURI() != null ? node.getNamespaceURI() : "";
        return string.equals(qName.getNamespaceURI()) && node.getLocalName().equals(qName.getLocalPart());
    }

    private static boolean matchingNamespace(Node node, Namespace namespace) {
        if (namespace == null) {
            return true;
        }
        return namespace.isSame(node.getNamespaceURI());
    }

    private static boolean matchingLocalName(Node node, String string) {
        if (string == null) {
            return true;
        }
        String string2 = node.getLocalName();
        return string.equals(string2);
    }

    private static boolean isAcceptedNode(Node node) {
        return DomUtil.isElement(node) || DomUtil.isText(node);
    }

    static boolean isElement(Node node) {
        return node.getNodeType() == 1;
    }

    static boolean isText(Node node) {
        short s = node.getNodeType();
        return s == 3 || s == 4;
    }

    public static Element createElement(Document document, String string, Namespace namespace) {
        if (namespace != null) {
            return document.createElementNS(namespace.getURI(), DomUtil.getPrefixedName(string, namespace));
        }
        return document.createElement(string);
    }

    public static Element createElement(Document document, String string, Namespace namespace, String string2) {
        Element element = DomUtil.createElement(document, string, namespace);
        DomUtil.setText(element, string2);
        return element;
    }

    public static Element addChildElement(Element element, String string, Namespace namespace) {
        Element element2 = DomUtil.createElement(element.getOwnerDocument(), string, namespace);
        element.appendChild(element2);
        return element2;
    }

    public static Element addChildElement(Node node, String string, Namespace namespace) {
        Document document = node.getOwnerDocument();
        if (node instanceof Document) {
            document = (Document)node;
        }
        Element element = DomUtil.createElement(document, string, namespace);
        node.appendChild(element);
        return element;
    }

    public static Element addChildElement(Element element, String string, Namespace namespace, String string2) {
        Element element2 = DomUtil.createElement(element.getOwnerDocument(), string, namespace, string2);
        element.appendChild(element2);
        return element2;
    }

    public static void setText(Element element, String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        Text text = element.getOwnerDocument().createTextNode(string);
        element.appendChild(text);
    }

    public static void setAttribute(Element element, String string, Namespace namespace, String string2) {
        if (namespace == null) {
            Attr attr = element.getOwnerDocument().createAttribute(string);
            attr.setValue(string2);
            element.setAttributeNode(attr);
        } else {
            Attr attr = element.getOwnerDocument().createAttributeNS(namespace.getURI(), DomUtil.getPrefixedName(string, namespace));
            attr.setValue(string2);
            element.setAttributeNodeNS(attr);
        }
    }

    public static void setNamespaceAttribute(Element element, String string, String string2) {
        if (Namespace.EMPTY_NAMESPACE.equals(Namespace.getNamespace(string, string2))) {
            log.debug("Empty namespace -> omit attribute setting.");
            return;
        }
        DomUtil.setAttribute(element, string, Namespace.XMLNS_NAMESPACE, string2);
    }

    public static Element timeoutToXml(long l, Document document) {
        boolean bl = l / 1000L > Integer.MAX_VALUE || l == Integer.MAX_VALUE;
        String string = bl ? "Infinite" : "Second-" + l / 1000L;
        return DomUtil.createElement(document, "timeout", DavConstants.NAMESPACE, string);
    }

    public static Element depthToXml(boolean bl, Document document) {
        return DomUtil.depthToXml(bl ? "infinity" : "0", document);
    }

    public static Element depthToXml(String string, Document document) {
        return DomUtil.createElement(document, "depth", DavConstants.NAMESPACE, string);
    }

    public static Element hrefToXml(String string, Document document) {
        return DomUtil.createElement(document, "href", DavConstants.NAMESPACE, string);
    }

    public static String getQualifiedName(String string, Namespace namespace) {
        return DomUtil.getExpandedName(string, namespace);
    }

    public static String getExpandedName(String string, Namespace namespace) {
        if (namespace == null || namespace.equals(Namespace.EMPTY_NAMESPACE)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(namespace.getURI()).append("}");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getPrefixedName(String string, Namespace namespace) {
        if (namespace == null || Namespace.EMPTY_NAMESPACE.equals(namespace) || Namespace.EMPTY_NAMESPACE.getPrefix().equals(namespace.getPrefix())) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(namespace.getPrefix());
        stringBuffer.append(":");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static void transformDocument(Document document, Writer writer) throws TransformerException, SAXException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        transformer.transform(new DOMSource(document), ResultHelper.getResult(new StreamResult(writer)));
    }

    public static void transformDocument(Document document, OutputStream outputStream) throws TransformerException, SAXException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        transformer.transform(new DOMSource(document), ResultHelper.getResult(new StreamResult(outputStream)));
    }
}

