/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionTreeReport
implements Report,
DeltaVConstants {
    private static Logger log = LoggerFactory.getLogger(VersionTreeReport.class);
    private ReportInfo info;
    private DavResource resource;

    @Override
    public ReportType getType() {
        return ReportType.VERSION_TREE;
    }

    @Override
    public boolean isMultiStatusReport() {
        return true;
    }

    @Override
    public void init(DavResource davResource, ReportInfo reportInfo) throws DavException {
        this.setResource(davResource);
        this.setInfo(reportInfo);
    }

    private void setResource(DavResource davResource) throws DavException {
        if (davResource == null || !(davResource instanceof VersionControlledResource) && !(davResource instanceof VersionResource)) {
            throw new DavException(400, "DAV:version-tree report can only be created for version-controlled resources and version resources.");
        }
        this.resource = davResource;
    }

    private void setInfo(ReportInfo reportInfo) throws DavException {
        if (!this.getType().isRequestedReportType(reportInfo)) {
            throw new DavException(400, "DAV:version-tree element expected.");
        }
        this.info = reportInfo;
    }

    @Override
    public Element toXml(Document document) {
        return this.getMultiStatus().toXml(document);
    }

    private MultiStatus getMultiStatus() {
        if (this.info == null || this.resource == null) {
            throw new NullPointerException("Error while running DAV:version-tree report");
        }
        MultiStatus multiStatus = new MultiStatus();
        this.buildResponse(this.resource, this.info.getPropertyNameSet(), this.info.getDepth(), multiStatus);
        return multiStatus;
    }

    private void buildResponse(DavResource davResource, DavPropertyNameSet davPropertyNameSet, int n, MultiStatus multiStatus) {
        Object object;
        try {
            VersionResource[] versionResourceArray = VersionTreeReport.getVersions(davResource);
            int n2 = versionResourceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = versionResourceArray[n3];
                if (davPropertyNameSet.isEmpty()) {
                    multiStatus.addResourceStatus((DavResource)object, 200, 0);
                } else {
                    multiStatus.addResourceProperties((DavResource)object, davPropertyNameSet, 0);
                }
                ++n3;
            }
        }
        catch (DavException davException) {
            log.error(davException.toString());
        }
        if (n > 0 && davResource.isCollection()) {
            object = davResource.getMembers();
            while (object.hasNext()) {
                this.buildResponse(object.nextResource(), davPropertyNameSet, n - 1, multiStatus);
            }
        }
    }

    private static VersionResource[] getVersions(DavResource davResource) throws DavException {
        VersionResource[] versionResourceArray = new VersionResource[]{};
        if (davResource instanceof VersionControlledResource) {
            versionResourceArray = ((VersionControlledResource)davResource).getVersionHistory().getVersions();
        } else if (davResource instanceof VersionResource) {
            versionResourceArray = ((VersionResource)davResource).getVersionHistory().getVersions();
        }
        return versionResourceArray;
    }
}

