/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedReportSetProperty
extends AbstractDavProperty<Set<ReportType>> {
    private static Logger log = LoggerFactory.getLogger(SupportedReportSetProperty.class);
    private final Set<ReportType> reportTypes = new HashSet<ReportType>();

    public SupportedReportSetProperty() {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
    }

    public SupportedReportSetProperty(ReportType[] reportTypeArray) {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
        ReportType[] reportTypeArray2 = reportTypeArray;
        int n = reportTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReportType reportType = reportTypeArray2[n2];
            this.addReportType(reportType);
            ++n2;
        }
    }

    public void addReportType(ReportType reportType) {
        this.reportTypes.add(reportType);
    }

    public boolean isSupportedReport(ReportInfo reportInfo) {
        for (ReportType reportType : this.reportTypes) {
            if (!reportType.isRequestedReportType(reportInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ReportType> getValue() {
        return this.reportTypes;
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.getName().toXml(document);
        for (ReportType reportType : this.reportTypes) {
            Element element2 = DomUtil.addChildElement(element, "supported-report", DeltaVConstants.NAMESPACE);
            Element element3 = DomUtil.addChildElement(element2, "report", DeltaVConstants.NAMESPACE);
            element3.appendChild(reportType.toXml(document));
        }
        return element;
    }
}

