/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashMap;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.report.ExpandPropertyReport;
import org.apache.jackrabbit.webdav.version.report.LocateByHistoryReport;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.VersionTreeReport;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportType
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(ReportType.class);
    private static final HashMap<String, ReportType> types = new HashMap();
    public static final ReportType VERSION_TREE = ReportType.register("version-tree", NAMESPACE, VersionTreeReport.class);
    public static final ReportType EXPAND_PROPERTY = ReportType.register("expand-property", NAMESPACE, ExpandPropertyReport.class);
    public static final ReportType LOCATE_BY_HISTORY = ReportType.register("locate-by-history", NAMESPACE, LocateByHistoryReport.class);
    private final String key;
    private final String localName;
    private final Namespace namespace;
    private final Class<? extends Report> reportClass;

    private ReportType(String string, Namespace namespace, String string2, Class<? extends Report> clazz) {
        this.localName = string;
        this.namespace = namespace;
        this.key = string2;
        this.reportClass = clazz;
    }

    public Report createReport(DeltaVResource deltaVResource, ReportInfo reportInfo) throws DavException {
        try {
            Report report = this.reportClass.newInstance();
            report.init(deltaVResource, reportInfo);
            return report;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DavException(500, "Failed to create new report (" + this.reportClass.getName() + ") from class: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new DavException(500, "Failed to create new report (" + this.reportClass.getName() + ") from class: " + instantiationException.getMessage());
        }
    }

    @Override
    public Element toXml(Document document) {
        return DomUtil.createElement(document, this.localName, this.namespace);
    }

    public boolean isRequestedReportType(ReportInfo reportInfo) {
        if (reportInfo != null) {
            return this.getReportName().equals(reportInfo.getReportName());
        }
        return false;
    }

    public String getReportName() {
        return this.key;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public static ReportType register(String string, Namespace namespace, Class<? extends Report> clazz) {
        XmlSerializable xmlSerializable;
        if (string == null || namespace == null || clazz == null) {
            throw new IllegalArgumentException("A ReportType cannot be registered with a null name, namespace or report class");
        }
        String string2 = DomUtil.getExpandedName(string, namespace);
        if (types.containsKey(string2)) {
            return types.get(string2);
        }
        try {
            xmlSerializable = clazz.newInstance();
            if (!(xmlSerializable instanceof Report)) {
                throw new IllegalArgumentException("Unable to register Report class: " + clazz + " does not implement the Report interface.");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Error while validating Report class: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Error while validating Report class.: " + instantiationException.getMessage());
        }
        xmlSerializable = new ReportType(string, namespace, string2, clazz);
        types.put(string2, (ReportType)xmlSerializable);
        return xmlSerializable;
    }

    public static ReportType getType(ReportInfo reportInfo) {
        if (reportInfo == null) {
            throw new IllegalArgumentException("ReportInfo must not be null.");
        }
        String string = reportInfo.getReportName();
        if (types.containsKey(string)) {
            return types.get(string);
        }
        throw new IllegalArgumentException("The request report '" + string + "' has not been registered yet.");
    }
}

