/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportInfo
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(ReportInfo.class);
    private final String typeLocalName;
    private final Namespace typeNamespace;
    private final int depth;
    private final DavPropertyNameSet propertyNames;
    private final List<Element> content = new ArrayList<Element>();

    public ReportInfo(ReportType reportType) {
        this(reportType, 0, null);
    }

    public ReportInfo(ReportType reportType, int n) {
        this(reportType, n, null);
    }

    public ReportInfo(ReportType reportType, int n, DavPropertyNameSet davPropertyNameSet) {
        this(reportType.getLocalName(), reportType.getNamespace(), n, davPropertyNameSet);
    }

    public ReportInfo(String string, Namespace namespace) {
        this(string, namespace, 0, null);
    }

    public ReportInfo(String string, Namespace namespace, int n, DavPropertyNameSet davPropertyNameSet) {
        this.typeLocalName = string;
        this.typeNamespace = namespace;
        this.depth = n;
        this.propertyNames = davPropertyNameSet != null ? new DavPropertyNameSet(davPropertyNameSet) : new DavPropertyNameSet();
    }

    public ReportInfo(Element element, int n) throws DavException {
        if (element == null) {
            log.warn("Report request body must not be null.");
            throw new DavException(400);
        }
        this.typeLocalName = element.getLocalName();
        this.typeNamespace = DomUtil.getNamespace(element);
        this.depth = n;
        Element element2 = DomUtil.getChildElement(element, "prop", DavConstants.NAMESPACE);
        if (element2 != null) {
            this.propertyNames = new DavPropertyNameSet(element2);
            element.removeChild(element2);
        } else {
            this.propertyNames = new DavPropertyNameSet();
        }
        ElementIterator elementIterator = DomUtil.getChildren(element);
        while (elementIterator.hasNext()) {
            Element element3 = elementIterator.nextElement();
            if ("prop".equals(element3.getLocalName())) continue;
            this.content.add(element3);
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public String getReportName() {
        return DomUtil.getExpandedName(this.typeLocalName, this.typeNamespace);
    }

    public boolean containsContentElement(String string, Namespace namespace) {
        if (this.content.isEmpty()) {
            return false;
        }
        for (Element element : this.content) {
            boolean bl;
            boolean bl2 = namespace == null ? element.getNamespaceURI() == null : (bl = namespace.isSame(element.getNamespaceURI()));
            if (!bl || !element.getLocalName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Element getContentElement(String string, Namespace namespace) {
        List<Element> list = this.getContentElements(string, namespace);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Element> getContentElements(String string, Namespace namespace) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.content) {
            if (!DomUtil.matches(element, string, namespace)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public void setContentElement(Element element) {
        this.content.add(element);
    }

    public DavPropertyNameSet getPropertyNameSet() {
        return this.propertyNames;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, this.typeLocalName, this.typeNamespace);
        if (!this.content.isEmpty()) {
            for (Element element2 : this.content) {
                Node node = document.importNode(element2, true);
                element.appendChild(node);
            }
        }
        if (!this.propertyNames.isEmpty()) {
            element.appendChild(this.propertyNames.toXml(document));
        }
        return element;
    }
}

