/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocateByHistoryReport
implements Report,
DeltaVConstants {
    private static Logger log = LoggerFactory.getLogger(LocateByHistoryReport.class);
    private ReportInfo info;
    private Set<String> vhHrefSet = new HashSet<String>();
    private DavResource resource;

    @Override
    public ReportType getType() {
        return ReportType.LOCATE_BY_HISTORY;
    }

    @Override
    public void init(DavResource davResource, ReportInfo reportInfo) throws DavException {
        if (davResource == null || !(davResource instanceof VersionControlledResource)) {
            throw new DavException(400, "DAV:version-tree report can only be created for version-controlled resources and version resources.");
        }
        this.resource = davResource;
        this.setInfo(reportInfo);
    }

    private void setInfo(ReportInfo reportInfo) throws DavException {
        if (reportInfo == null || !this.getType().isRequestedReportType(reportInfo)) {
            throw new DavException(400, "DAV:locate-by-history element expected.");
        }
        Element element = reportInfo.getContentElement("version-history-set", NAMESPACE);
        if (element == null) {
            throw new DavException(400, "The DAV:locate-by-history element must contain a DAV:version-history-set child.");
        }
        ElementIterator elementIterator = DomUtil.getChildren(element, "href", DavConstants.NAMESPACE);
        while (elementIterator.hasNext()) {
            String string = DomUtil.getText(elementIterator.nextElement());
            if (string == null) continue;
            this.vhHrefSet.add(string);
        }
        this.info = reportInfo;
    }

    @Override
    public boolean isMultiStatusReport() {
        return true;
    }

    @Override
    public Element toXml(Document document) {
        return this.getMultiStatus().toXml(document);
    }

    private MultiStatus getMultiStatus() {
        MultiStatus multiStatus = new MultiStatus();
        this.buildResponse(this.resource, this.info.getPropertyNameSet(), this.info.getDepth(), multiStatus);
        return multiStatus;
    }

    private void buildResponse(DavResource davResource, DavPropertyNameSet davPropertyNameSet, int n, MultiStatus multiStatus) {
        DavResourceIterator davResourceIterator = davResource.getMembers();
        while (!this.vhHrefSet.isEmpty() && davResourceIterator.hasNext()) {
            DavResource davResource2 = davResourceIterator.nextResource();
            if (davResource2 instanceof VersionControlledResource) {
                try {
                    VersionHistoryResource versionHistoryResource = ((VersionControlledResource)davResource2).getVersionHistory();
                    if (this.vhHrefSet.remove(versionHistoryResource.getHref())) {
                        if (davPropertyNameSet.isEmpty()) {
                            multiStatus.addResourceStatus(davResource2, 200, 0);
                        } else {
                            multiStatus.addResourceProperties(davResource2, davPropertyNameSet, 0);
                        }
                    }
                }
                catch (DavException davException) {
                    log.info(davException.getMessage());
                }
            }
            if (n <= 0) continue;
            this.buildResponse(davResourceIterator.nextResource(), davPropertyNameSet, n - 1, multiStatus);
        }
    }
}

