/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpandPropertyReport
implements Report,
DeltaVConstants {
    private static Logger log = LoggerFactory.getLogger(ExpandPropertyReport.class);
    private DavResource resource;
    private ReportInfo info;
    private Iterator<Element> propertyElements;

    @Override
    public ReportType getType() {
        return ReportType.EXPAND_PROPERTY;
    }

    @Override
    public boolean isMultiStatusReport() {
        return true;
    }

    @Override
    public void init(DavResource davResource, ReportInfo reportInfo) throws DavException {
        this.setResource(davResource);
        this.setInfo(reportInfo);
    }

    private void setResource(DavResource davResource) throws DavException {
        if (davResource == null) {
            throw new DavException(400, "The resource specified must not be null.");
        }
        this.resource = davResource;
    }

    private void setInfo(ReportInfo reportInfo) throws DavException {
        if (reportInfo == null) {
            throw new DavException(400, "The report info specified must not be null.");
        }
        if (!this.getType().isRequestedReportType(reportInfo)) {
            throw new DavException(400, "DAV:expand-property element expected.");
        }
        this.info = reportInfo;
        this.propertyElements = reportInfo.getContentElements("property", NAMESPACE).iterator();
    }

    @Override
    public Element toXml(Document document) {
        return this.getMultiStatus().toXml(document);
    }

    private MultiStatus getMultiStatus() {
        MultiStatus multiStatus = new MultiStatus();
        this.addResponses(this.resource, this.info.getDepth(), multiStatus);
        return multiStatus;
    }

    private void addResponses(DavResource davResource, int n, MultiStatus multiStatus) {
        MultiStatusResponse multiStatusResponse = this.getResponse(davResource, this.propertyElements);
        multiStatus.addResponse(multiStatusResponse);
        if (n > 0 && davResource.isCollection()) {
            DavResourceIterator davResourceIterator = davResource.getMembers();
            while (davResourceIterator.hasNext()) {
                this.addResponses(davResourceIterator.nextResource(), n - 1, multiStatus);
            }
        }
    }

    private MultiStatusResponse getResponse(DavResource davResource, Iterator<Element> iterator) {
        MultiStatusResponse multiStatusResponse = new MultiStatusResponse(davResource.getHref(), null);
        while (iterator.hasNext()) {
            Element element = iterator.next();
            String string = element.getAttribute("name");
            if (string == null || "".equals(string)) continue;
            String string2 = element.getAttribute("namespace");
            Namespace namespace = string2 != null ? Namespace.getNamespace(string2) : NAMESPACE;
            DavPropertyName davPropertyName = DavPropertyName.create(string, namespace);
            DavProperty<?> davProperty = davResource.getProperty(davPropertyName);
            if (davProperty != null) {
                if (davProperty instanceof HrefProperty && davResource instanceof DeltaVResource) {
                    ElementIterator elementIterator = DomUtil.getChildren(element, "property", NAMESPACE);
                    multiStatusResponse.add(new ExpandProperty((DeltaVResource)davResource, (HrefProperty)davProperty, elementIterator));
                    continue;
                }
                multiStatusResponse.add(davProperty);
                continue;
            }
            multiStatusResponse.add(davPropertyName, 404);
        }
        return multiStatusResponse;
    }

    private class ExpandProperty
    extends AbstractDavProperty<List<MultiStatusResponse>> {
        private List<MultiStatusResponse> valueList;

        private ExpandProperty(DeltaVResource deltaVResource, HrefProperty hrefProperty, ElementIterator elementIterator) {
            super(hrefProperty.getName(), hrefProperty.isInvisibleInAllprop());
            this.valueList = new ArrayList<MultiStatusResponse>();
            try {
                DavResource[] davResourceArray;
                DavResource[] davResourceArray2 = davResourceArray = deltaVResource.getReferenceResources(hrefProperty.getName());
                int n = davResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DavResource davResource = davResourceArray2[n2];
                    MultiStatusResponse multiStatusResponse = ExpandPropertyReport.this.getResponse(davResource, elementIterator);
                    this.valueList.add(multiStatusResponse);
                    ++n2;
                }
            }
            catch (DavException davException) {
                log.error(davException.getMessage());
            }
        }

        @Override
        public List<MultiStatusResponse> getValue() {
            return this.valueList;
        }
    }
}

