/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.BaselineResource;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompareBaselineReport
implements Report {
    private static Logger log = LoggerFactory.getLogger(CompareBaselineReport.class);
    private static final String XML_COMPARE_BASELINE = "compare-baseline";
    private static final String XML_COMPARE_BASELINE_REPORT = "compare-baseline-report";
    private static final String XML_ADDED_VERSION = "added-version";
    private static final String XML_DELETED_VERSION = "deleted-version";
    private static final String XML_CHANGED_VERSION = "changed-version";
    public static final ReportType COMPARE_BASELINE = ReportType.register("compare-baseline", DeltaVConstants.NAMESPACE, CompareBaselineReport.class);
    private BaselineResource requestBaseline;
    private BaselineResource compareBaseline;

    @Override
    public ReportType getType() {
        return COMPARE_BASELINE;
    }

    @Override
    public boolean isMultiStatusReport() {
        return false;
    }

    @Override
    public void init(DavResource davResource, ReportInfo reportInfo) throws DavException {
        if (!this.getType().isRequestedReportType(reportInfo)) {
            throw new DavException(400, "DAV:compare-baseline element expected.");
        }
        if (davResource == null || !(davResource instanceof BaselineResource)) {
            throw new DavException(400, "DAV:compare-baseline report can only be created for a baseline resource.");
        }
        this.requestBaseline = (BaselineResource)davResource;
        String string = DomUtil.getText(reportInfo.getContentElement("href", DavConstants.NAMESPACE));
        DavResourceLocator davResourceLocator = davResource.getLocator();
        DavResourceLocator davResourceLocator2 = davResourceLocator.getFactory().createResourceLocator(davResourceLocator.getPrefix(), string);
        DavResource davResource2 = davResource.getFactory().createResource(davResourceLocator2, davResource.getSession());
        if (!(davResource2 instanceof BaselineResource)) {
            throw new DavException(400, "DAV:latest-activity-version report: The DAV:href in the request body MUST identify an activity.");
        }
        this.compareBaseline = (BaselineResource)davResource2;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, XML_COMPARE_BASELINE_REPORT, DeltaVConstants.NAMESPACE);
        try {
            Object object;
            ArrayList<VersionResource> arrayList = new ArrayList<VersionResource>();
            this.getVersions(this.requestBaseline.getBaselineCollection(), arrayList);
            ArrayList<VersionResource> arrayList2 = new ArrayList<VersionResource>();
            this.getVersions(this.compareBaseline.getBaselineCollection(), arrayList2);
            for (VersionResource versionResource : arrayList) {
                Element element2;
                if (arrayList2.remove(versionResource)) continue;
                object = this.findChangedVersion(versionResource, arrayList2);
                if (object != null) {
                    element2 = DomUtil.addChildElement(element, XML_CHANGED_VERSION, DeltaVConstants.NAMESPACE);
                    element2.appendChild(DomUtil.hrefToXml(versionResource.getHref(), document));
                    element2.appendChild(DomUtil.hrefToXml(object.getHref(), document));
                    continue;
                }
                element2 = DomUtil.addChildElement(element, XML_DELETED_VERSION, DeltaVConstants.NAMESPACE);
                element2.appendChild(DomUtil.hrefToXml(versionResource.getHref(), document));
            }
            for (VersionResource versionResource : arrayList2) {
                object = DomUtil.addChildElement(element, XML_ADDED_VERSION, DeltaVConstants.NAMESPACE);
                object.appendChild(DomUtil.hrefToXml(versionResource.getHref(), document));
            }
        }
        catch (DavException davException) {
            log.error("Internal error while building report", (Throwable)davException);
        }
        return element;
    }

    private void getVersions(DavResource davResource, List<VersionResource> list) throws DavException {
        DavResourceIterator davResourceIterator = davResource.getMembers();
        while (davResourceIterator.hasNext()) {
            DavResource davResource2 = davResourceIterator.nextResource();
            if (davResource2 instanceof VersionControlledResource) {
                String string = new HrefProperty(davResource2.getProperty(VersionControlledResource.CHECKED_IN)).getHrefs().get(0);
                DavResourceLocator davResourceLocator = davResource2.getLocator();
                DavResourceLocator davResourceLocator2 = davResourceLocator.getFactory().createResourceLocator(davResourceLocator.getPrefix(), string);
                DavResource davResource3 = davResource2.getFactory().createResource(davResourceLocator2, davResource2.getSession());
                if (davResource3 instanceof VersionResource) {
                    list.add((VersionResource)davResource3);
                } else {
                    log.error("Internal error: DAV:checked-in property must point to a VersionResource.");
                }
            }
            if (!davResource2.isCollection()) continue;
            this.getVersions(davResource2, list);
        }
    }

    private VersionResource findChangedVersion(VersionResource versionResource, List<VersionResource> list) throws DavException {
        VersionResource[] versionResourceArray;
        VersionResource[] versionResourceArray2 = versionResourceArray = versionResource.getVersionHistory().getVersions();
        int n = versionResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionResource versionResource2 = versionResourceArray2[n2];
            if (list.remove(versionResource2)) {
                return versionResource2;
            }
            ++n2;
        }
        return null;
    }
}

