/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.ArrayList;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateInfo
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(UpdateInfo.class);
    public static final int UPDATE_BY_VERSION = 0;
    public static final int UPDATE_BY_LABEL = 1;
    public static final int UPDATE_BY_WORKSPACE = 2;
    private Element updateElement;
    private DavPropertyNameSet propertyNameSet = new DavPropertyNameSet();
    private String[] source;
    private int type;

    public UpdateInfo(String[] stringArray, int n, DavPropertyNameSet davPropertyNameSet) {
        String[] stringArray2;
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Version href array must not be null and have a minimal length of 1.");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Illegal type of UpdateInfo.");
        }
        this.type = n;
        if (n == 0) {
            stringArray2 = stringArray;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = stringArray[0];
        }
        this.source = stringArray2;
        if (davPropertyNameSet != null) {
            this.propertyNameSet = davPropertyNameSet;
        }
    }

    public UpdateInfo(Element element) throws DavException {
        Element element2;
        if (!DomUtil.matches(element, "update", NAMESPACE)) {
            log.warn("DAV:update element expected");
            throw new DavException(400);
        }
        boolean bl = false;
        if (DomUtil.hasChildElement(element, "version", NAMESPACE)) {
            element2 = DomUtil.getChildElement(element, "version", NAMESPACE);
            ElementIterator elementIterator = DomUtil.getChildren(element2, "href", DavConstants.NAMESPACE);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (elementIterator.hasNext()) {
                arrayList.add(DomUtil.getText(elementIterator.nextElement()));
            }
            this.source = arrayList.toArray(new String[arrayList.size()]);
            this.type = 0;
            bl = true;
        }
        if (!bl && DomUtil.hasChildElement(element, "label-name", NAMESPACE)) {
            this.source = new String[]{DomUtil.getChildText(element, "label-name", NAMESPACE)};
            this.type = 1;
            bl = true;
        }
        if (!bl) {
            element2 = DomUtil.getChildElement(element, "workspace", NAMESPACE);
            if (element2 != null) {
                this.source = new String[]{DomUtil.getChildTextTrim(element2, "href", DavConstants.NAMESPACE)};
                this.type = 2;
            } else {
                log.warn("DAV:update element must contain either DAV:version, DAV:label-name or DAV:workspace child element.");
                throw new DavException(400);
            }
        }
        if (DomUtil.hasChildElement(element, "prop", DavConstants.NAMESPACE)) {
            element2 = DomUtil.getChildElement(element, "prop", DavConstants.NAMESPACE);
            this.propertyNameSet = new DavPropertyNameSet(element2);
            element.removeChild(element2);
        } else {
            this.propertyNameSet = new DavPropertyNameSet();
        }
        this.updateElement = element;
    }

    public String[] getVersionHref() {
        return this.type == 0 ? this.source : null;
    }

    public String[] getLabelName() {
        return this.type == 1 ? this.source : null;
    }

    public String getWorkspaceHref() {
        return this.type == 2 ? this.source[0] : null;
    }

    public DavPropertyNameSet getPropertyNameSet() {
        return this.propertyNameSet;
    }

    public Element getUpdateElement() {
        return this.updateElement;
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.updateElement != null ? (Element)document.importNode(this.updateElement, true) : UpdateInfo.createUpdateElement(this.source, this.type, document);
        if (!this.propertyNameSet.isEmpty()) {
            element.appendChild(this.propertyNameSet.toXml(document));
        }
        return element;
    }

    public static Element createUpdateElement(String[] stringArray, int n, Document document) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Update source must specific at least a single resource used to run the update.");
        }
        Element element = DomUtil.createElement(document, "update", NAMESPACE);
        switch (n) {
            case 0: {
                Element element2 = DomUtil.addChildElement(element, "version", NAMESPACE);
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray2[n3];
                    element2.appendChild(DomUtil.hrefToXml(string, document));
                    ++n3;
                }
                break;
            }
            case 1: {
                DomUtil.addChildElement(element, "label-name", NAMESPACE, stringArray[0]);
                break;
            }
            case 2: {
                Element element3 = DomUtil.addChildElement(element, "workspace", NAMESPACE, stringArray[0]);
                element3.appendChild(DomUtil.hrefToXml(stringArray[0], document));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid update type: " + n);
            }
        }
        return element;
    }
}

