/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedMethodSetProperty
extends AbstractDavProperty<String[]>
implements DeltaVConstants {
    private static Logger log = LoggerFactory.getLogger(SupportedMethodSetProperty.class);
    private final String[] methods;

    public SupportedMethodSetProperty(String[] stringArray) {
        super(DeltaVConstants.SUPPORTED_METHOD_SET, true);
        this.methods = stringArray;
    }

    @Override
    public String[] getValue() {
        return this.methods;
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.getName().toXml(document);
        String[] stringArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Element element2 = DomUtil.addChildElement(element, "supported-method", DeltaVConstants.NAMESPACE);
            DomUtil.setAttribute(element2, "name", DeltaVConstants.NAMESPACE, string);
            ++n2;
        }
        return element;
    }
}

