/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionsResponse
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(OptionsResponse.class);
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public void addEntry(String string, Namespace namespace, String[] stringArray) {
        Entry entry = new Entry(string, namespace, stringArray);
        this.entries.put(DomUtil.getExpandedName(string, namespace), entry);
    }

    public String[] getHrefs(String string, Namespace namespace) {
        String string2 = DomUtil.getExpandedName(string, namespace);
        if (this.entries.containsKey(string2)) {
            return this.entries.get(string2).hrefs;
        }
        return new String[0];
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, "options-response", NAMESPACE);
        for (Entry entry : this.entries.values()) {
            Element element2 = DomUtil.addChildElement(element, entry.localName, entry.namespace);
            String[] stringArray = entry.hrefs;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                element2.appendChild(DomUtil.hrefToXml(string, document));
                ++n2;
            }
        }
        return element;
    }

    public static OptionsResponse createFromXml(Element element) {
        if (!DomUtil.matches(element, "options-response", NAMESPACE)) {
            throw new IllegalArgumentException("DAV:options-response element expected");
        }
        OptionsResponse optionsResponse = new OptionsResponse();
        ElementIterator elementIterator = DomUtil.getChildren(element);
        while (elementIterator.hasNext()) {
            Element element2 = elementIterator.nextElement();
            ArrayList<String> arrayList = new ArrayList<String>();
            ElementIterator elementIterator2 = DomUtil.getChildren(element2, "href", DavConstants.NAMESPACE);
            while (elementIterator2.hasNext()) {
                arrayList.add(DomUtil.getTextTrim(elementIterator2.nextElement()));
            }
            optionsResponse.addEntry(element2.getLocalName(), DomUtil.getNamespace(element2), arrayList.toArray(new String[arrayList.size()]));
        }
        return optionsResponse;
    }

    private static class Entry {
        private final String localName;
        private final Namespace namespace;
        private final String[] hrefs;

        private Entry(String string, Namespace namespace, String[] stringArray) {
            this.localName = string;
            this.namespace = namespace;
            this.hrefs = stringArray;
        }
    }
}

