/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionsInfo
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(OptionsInfo.class);
    private final Set<String> entriesLocalNames = new HashSet<String>();

    public OptionsInfo(String[] stringArray) {
        if (stringArray != null) {
            this.entriesLocalNames.addAll(Arrays.asList(stringArray));
        }
    }

    private OptionsInfo() {
    }

    public boolean containsElement(String string, Namespace namespace) {
        if (DeltaVConstants.NAMESPACE.equals(namespace)) {
            return this.entriesLocalNames.contains(string);
        }
        return false;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, "options", DeltaVConstants.NAMESPACE);
        for (String string : this.entriesLocalNames) {
            DomUtil.addChildElement(element, string, DeltaVConstants.NAMESPACE);
        }
        return element;
    }

    public static OptionsInfo createFromXml(Element element) throws DavException {
        if (!DomUtil.matches(element, "options", DeltaVConstants.NAMESPACE)) {
            log.warn("DAV:options element expected");
            throw new DavException(400);
        }
        OptionsInfo optionsInfo = new OptionsInfo();
        ElementIterator elementIterator = DomUtil.getChildren(element);
        while (elementIterator.hasNext()) {
            optionsInfo.entriesLocalNames.add(elementIterator.nextElement().getLocalName());
        }
        return optionsInfo;
    }
}

