/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.ArrayList;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MergeInfo
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(MergeInfo.class);
    private final Element mergeElement;
    private final DavPropertyNameSet propertyNameSet;

    public MergeInfo(Element element) throws DavException {
        if (!DomUtil.matches(element, "merge", NAMESPACE)) {
            log.warn("'DAV:merge' element expected");
            throw new DavException(400);
        }
        Element element2 = DomUtil.getChildElement(element, "prop", DavConstants.NAMESPACE);
        if (element2 != null) {
            this.propertyNameSet = new DavPropertyNameSet(element2);
            element.removeChild(element2);
        } else {
            this.propertyNameSet = new DavPropertyNameSet();
        }
        this.mergeElement = element;
    }

    public String[] getSourceHrefs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element = DomUtil.getChildElement(this.mergeElement, "source", DavConstants.NAMESPACE);
        if (element != null) {
            ElementIterator elementIterator = DomUtil.getChildren(element, "href", DavConstants.NAMESPACE);
            while (elementIterator.hasNext()) {
                String string = DomUtil.getTextTrim(elementIterator.nextElement());
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isNoAutoMerge() {
        return DomUtil.hasChildElement(this.mergeElement, "no-auto-merge", NAMESPACE);
    }

    public boolean isNoCheckout() {
        return DomUtil.hasChildElement(this.mergeElement, "no-checkout", NAMESPACE);
    }

    public DavPropertyNameSet getPropertyNameSet() {
        return this.propertyNameSet;
    }

    public Element getMergeElement() {
        return this.mergeElement;
    }

    @Override
    public Element toXml(Document document) {
        Element element = (Element)document.importNode(this.mergeElement, true);
        if (!this.propertyNameSet.isEmpty()) {
            element.appendChild(this.propertyNameSet.toXml(document));
        }
        return element;
    }

    public static Element createMergeElement(String[] stringArray, boolean bl, boolean bl2, Document document) {
        Element element = DomUtil.createElement(document, "merge", NAMESPACE);
        Element element2 = DomUtil.addChildElement(element, "source", DavConstants.NAMESPACE);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            element2.appendChild(DomUtil.hrefToXml(string, document));
            ++n2;
        }
        if (bl) {
            DomUtil.addChildElement(element, "no-auto-merge", NAMESPACE);
        }
        if (bl2) {
            DomUtil.addChildElement(element, "no-checkout", NAMESPACE);
        }
        return element;
    }
}

