/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LabelSetProperty
extends AbstractDavProperty<String[]> {
    private static Logger log = LoggerFactory.getLogger(LabelSetProperty.class);
    private final String[] value;

    public LabelSetProperty(String[] stringArray) {
        super(VersionResource.LABEL_NAME_SET, true);
        this.value = stringArray;
    }

    @Override
    public String[] getValue() {
        return this.value;
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.getName().toXml(document);
        String[] stringArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            DomUtil.addChildElement(element, "label-name", DeltaVConstants.NAMESPACE, string);
            ++n2;
        }
        return element;
    }
}

