/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LabelInfo
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(LabelInfo.class);
    public static final int TYPE_SET = 0;
    public static final int TYPE_REMOVE = 1;
    public static final int TYPE_ADD = 2;
    public static String[] typeNames = new String[]{"set", "remove", "add"};
    private final int depth;
    private final int type;
    private final String labelName;

    public LabelInfo(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Label name must not be null.");
        }
        boolean bl = false;
        int n = 0;
        while (n < typeNames.length) {
            if (typeNames[n].equals(string2)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid type: " + string2);
        }
        this.type = n;
        this.labelName = string;
        this.depth = 0;
    }

    public LabelInfo(String string, int n) {
        this(string, n, 0);
    }

    public LabelInfo(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("Label name must not be null.");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid type: " + n);
        }
        this.labelName = string;
        this.type = n;
        this.depth = n2;
    }

    public LabelInfo(Element element, int n) throws DavException {
        if (!DomUtil.matches(element, "label", DeltaVConstants.NAMESPACE)) {
            log.warn("DAV:label element expected");
            throw new DavException(400);
        }
        String string = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < typeNames.length && n2 == -1) {
            if (DomUtil.hasChildElement(element, typeNames[n3], NAMESPACE)) {
                n2 = n3;
                Element element2 = DomUtil.getChildElement(element, typeNames[n3], NAMESPACE);
                string = DomUtil.getChildText(element2, "label-name", NAMESPACE);
            }
            ++n3;
        }
        if (string == null) {
            log.warn("DAV:label element must contain at least one set, add or remove element defining a label-name.");
            throw new DavException(400);
        }
        this.labelName = string;
        this.type = n2;
        this.depth = n;
    }

    public LabelInfo(Element element) throws DavException {
        this(element, 0);
    }

    public String getLabelName() {
        return this.labelName;
    }

    public int getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, "label", NAMESPACE);
        Element element2 = DomUtil.addChildElement(element, typeNames[this.type], NAMESPACE);
        DomUtil.addChildElement(element2, "label-name", NAMESPACE, this.labelName);
        return element;
    }
}

