/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodeUtil {
    private static final Logger log = LoggerFactory.getLogger(EncodeUtil.class);
    public static final char[] hexTable = "0123456789abcdef".toCharArray();
    private static BitSet URISave = new BitSet(256);
    private static BitSet URISaveEx;

    static {
        int n = 97;
        while (n <= 122) {
            URISave.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            URISave.set(n);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            URISave.set(n);
            ++n;
        }
        URISave.set(45);
        URISave.set(95);
        URISave.set(46);
        URISave.set(33);
        URISave.set(126);
        URISave.set(42);
        URISave.set(39);
        URISave.set(40);
        URISave.set(41);
        URISaveEx = (BitSet)URISave.clone();
        URISaveEx.set(47);
    }

    public static String escape(String string) {
        return EncodeUtil.escape(string, '%', false);
    }

    public static String escapePath(String string) {
        return EncodeUtil.escape(string, '%', true);
    }

    private static String escape(String string, char c, boolean bl) {
        try {
            BitSet bitSet = bl ? URISaveEx : URISave;
            byte[] byArray = string.getBytes("utf-8");
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            byte[] byArray2 = byArray;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray2[n2];
                int n3 = by & 0xFF;
                if (bitSet.get(n3) && n3 != c) {
                    stringBuffer.append((char)n3);
                } else {
                    stringBuffer.append(c);
                    stringBuffer.append(hexTable[n3 >> 4 & 0xF]);
                    stringBuffer.append(hexTable[n3 & 0xF]);
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public static String unescape(String string) {
        return EncodeUtil.unescape(string, '%');
    }

    private static String unescape(String string, char c) {
        try {
            byte[] byArray = string.getBytes("utf-8");
            if (byArray.length >= 1 && byArray[byArray.length - 1] == c || byArray.length >= 2 && byArray[byArray.length - 2] == c) {
                throw new IllegalArgumentException("Premature end of escape sequence at end of input");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            int n = 0;
            while (n < byArray.length) {
                byte by = byArray[n];
                if (by == c) {
                    byteArrayOutputStream.write((EncodeUtil.decodeDigit(byArray[++n]) << 4) + EncodeUtil.decodeDigit(byArray[++n]));
                } else {
                    byteArrayOutputStream.write(by);
                }
                ++n;
            }
            return new String(byteArrayOutputStream.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    private static byte decodeDigit(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 55);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 87);
        }
        throw new IllegalArgumentException("Escape sequence is not hexadecimal: " + (char)by);
    }

    private EncodeUtil() {
    }
}

