/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceType
extends AbstractDavProperty<Set<XmlSerializable>> {
    public static final int DEFAULT_RESOURCE = 0;
    public static final int COLLECTION = 1;
    public static final int VERSION_HISTORY = 2;
    public static final int ACTIVITY = 3;
    public static final int BASELINE = 4;
    private static final List<TypeName> NAMES = new ArrayList<TypeName>();
    private final int[] resourceTypes;

    static {
        NAMES.add(null);
        NAMES.add(new TypeName("collection", NAMESPACE));
        NAMES.add(new TypeName("version-history", DeltaVConstants.NAMESPACE));
        NAMES.add(new TypeName("activity", DeltaVConstants.NAMESPACE));
        NAMES.add(new TypeName("baseline", DeltaVConstants.NAMESPACE));
    }

    public ResourceType(int n) {
        this(new int[]{n});
    }

    public ResourceType(int[] nArray) {
        super(DavPropertyName.RESOURCETYPE, false);
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (!ResourceType.isValidResourceType(n3)) {
                throw new IllegalArgumentException("Invalid resource type '" + n3 + "'.");
            }
            ++n2;
        }
        this.resourceTypes = nArray;
    }

    @Override
    public Set<XmlSerializable> getValue() {
        HashSet<XmlSerializable> hashSet = new HashSet<XmlSerializable>();
        int[] nArray = this.resourceTypes;
        int n = this.resourceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            TypeName typeName = NAMES.get(n3);
            if (typeName != null) {
                hashSet.add(typeName);
            }
            ++n2;
        }
        return hashSet;
    }

    public int[] getResourceTypes() {
        return this.resourceTypes;
    }

    private static boolean isValidResourceType(int n) {
        return n >= 0 && n <= NAMES.size() - 1;
    }

    public static int registerResourceType(String string, Namespace namespace) {
        if (string == null || namespace == null) {
            throw new IllegalArgumentException("Cannot register a <null> resourcetype");
        }
        TypeName typeName = new TypeName(string, namespace);
        if (NAMES.contains(typeName)) {
            return NAMES.indexOf(typeName);
        }
        if (NAMES.add(typeName)) {
            return NAMES.size() - 1;
        }
        throw new IllegalArgumentException("Could not register resourcetype " + namespace.getPrefix() + string);
    }

    private static class TypeName
    implements XmlSerializable {
        private final String localName;
        private final Namespace namespace;
        private final int hashCode;

        private TypeName(String string, Namespace namespace) {
            this.localName = string;
            this.namespace = namespace;
            this.hashCode = DomUtil.getExpandedName(string, namespace).hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeName) {
                return this.hashCode == ((TypeName)object).hashCode;
            }
            return false;
        }

        @Override
        public Element toXml(Document document) {
            return DomUtil.createElement(document, this.localName, this.namespace);
        }
    }
}

