/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HrefProperty
extends AbstractDavProperty<String[]> {
    private static Logger log = LoggerFactory.getLogger(HrefProperty.class);
    private final String[] value;

    public HrefProperty(DavPropertyName davPropertyName, String string, boolean bl) {
        super(davPropertyName, bl);
        this.value = new String[]{string};
    }

    public HrefProperty(DavPropertyName davPropertyName, String[] stringArray, boolean bl) {
        super(davPropertyName, bl);
        this.value = stringArray;
    }

    public HrefProperty(DavProperty<?> davProperty) {
        super(davProperty.getName(), davProperty.isInvisibleInAllprop());
        if (davProperty instanceof HrefProperty) {
            this.value = ((HrefProperty)davProperty).value;
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object obj = davProperty.getValue();
            if (obj instanceof List) {
                for (Object e : (List)obj) {
                    if (e instanceof Element && "href".equals(((Element)e).getLocalName())) {
                        String string = DomUtil.getText((Element)e);
                        if (string != null) {
                            arrayList.add(string);
                            continue;
                        }
                        log.warn("Valid DAV:href element expected instead of " + e.toString());
                        continue;
                    }
                    log.warn("DAV: href element expected in the content of " + this.getName().toString());
                }
            } else if (obj instanceof Element && "href".equals(((Element)obj).getLocalName())) {
                String string = DomUtil.getTextTrim((Element)obj);
                if (string != null) {
                    arrayList.add(string);
                } else {
                    log.warn("Valid DAV:href element expected instead of " + obj.toString());
                }
            }
            this.value = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.getName().toXml(document);
        String[] stringArray = this.getValue();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                element.appendChild(DomUtil.hrefToXml(string, document));
                ++n2;
            }
        }
        return element;
    }

    @Override
    public String[] getValue() {
        return this.value;
    }

    public List<String> getHrefs() {
        return this.value != null ? Arrays.asList(this.value) : new ArrayList();
    }
}

