/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.List;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultDavProperty<T>
extends AbstractDavProperty<T> {
    private static Logger log = LoggerFactory.getLogger(DefaultDavProperty.class);
    private final T value;

    public DefaultDavProperty(String string, T t, Namespace namespace, boolean bl) {
        super(DavPropertyName.create(string, namespace), bl);
        this.value = t;
    }

    public DefaultDavProperty(String string, T t, Namespace namespace) {
        this(string, t, namespace, false);
    }

    public DefaultDavProperty(DavPropertyName davPropertyName, T t, boolean bl) {
        super(davPropertyName, bl);
        this.value = t;
    }

    public DefaultDavProperty(DavPropertyName davPropertyName, T t) {
        this(davPropertyName, t, false);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public static DefaultDavProperty<?> createFromXml(Element element) {
        Node node;
        List<Node> list;
        if (element == null) {
            throw new IllegalArgumentException("Cannot create a new DavProperty from a 'null' element.");
        }
        DavPropertyName davPropertyName = DavPropertyName.createFromXml(element);
        DefaultDavProperty<Object> defaultDavProperty = !DomUtil.hasContent(element) ? new DefaultDavProperty<Object>(davPropertyName, null, false) : ((list = DomUtil.getContent(element)).size() == 1 ? ((node = list.get(0)) instanceof Element ? new DefaultDavProperty<Element>(davPropertyName, (Element)node, false) : new DefaultDavProperty<String>(davPropertyName, node.getNodeValue(), false)) : new DefaultDavProperty<List<Node>>(davPropertyName, list, false));
        return defaultDavProperty;
    }
}

