/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.PropContainer;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DavPropertySet
extends PropContainer
implements Iterable<DavProperty<?>> {
    private static Logger log = LoggerFactory.getLogger(DavPropertySet.class);
    private final Map<DavPropertyName, DavProperty<?>> map = new HashMap();

    public DavProperty<?> add(DavProperty<?> davProperty) {
        return this.map.put(davProperty.getName(), davProperty);
    }

    public void addAll(DavPropertySet davPropertySet) {
        this.map.putAll(davPropertySet.map);
    }

    public DavProperty<?> get(String string) {
        return this.get(DavPropertyName.create(string));
    }

    public DavProperty<?> get(String string, Namespace namespace) {
        return this.get(DavPropertyName.create(string, namespace));
    }

    public DavProperty<?> get(DavPropertyName davPropertyName) {
        return this.map.get(davPropertyName);
    }

    public DavProperty<?> remove(DavPropertyName davPropertyName) {
        return this.map.remove(davPropertyName);
    }

    public DavProperty<?> remove(String string) {
        return this.remove(DavPropertyName.create(string));
    }

    public DavProperty<?> remove(String string, Namespace namespace) {
        return this.remove(DavPropertyName.create(string, namespace));
    }

    public DavPropertyIterator iterator() {
        return new PropIter();
    }

    public DavPropertyIterator iterator(Namespace namespace) {
        return new PropIter(namespace);
    }

    public DavPropertyName[] getPropertyNames() {
        return this.map.keySet().toArray(new DavPropertyName[this.map.keySet().size()]);
    }

    @Override
    public boolean contains(DavPropertyName davPropertyName) {
        return this.map.containsKey(davPropertyName);
    }

    @Override
    public boolean addContent(PropEntry propEntry) {
        if (propEntry instanceof DavProperty) {
            this.add((DavProperty)propEntry);
            return true;
        }
        log.debug("DavProperty object expected. Found: " + propEntry.getClass().toString());
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int getContentSize() {
        return this.map.size();
    }

    @Override
    public Collection<? extends PropEntry> getContent() {
        return this.map.values();
    }

    private class PropIter
    implements DavPropertyIterator {
        private final Namespace namespace;
        private final Iterator<DavProperty<?>> iterator;
        private DavProperty<?> next;

        private PropIter() {
            this((Namespace)null);
        }

        private PropIter(Namespace namespace) {
            this.namespace = namespace;
            this.iterator = DavPropertySet.this.map.values().iterator();
            this.seek();
        }

        @Override
        public DavProperty<?> nextProperty() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            DavProperty<?> davProperty = this.next;
            this.seek();
            return davProperty;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DavProperty<?> next() {
            return this.nextProperty();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (this.namespace != null && !this.namespace.equals(this.next.getName().getNamespace())) continue;
                return;
            }
            this.next = null;
        }
    }
}

