/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import org.apache.jackrabbit.webdav.property.PropContainer;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DavPropertyNameSet
extends PropContainer
implements Iterable<DavPropertyName> {
    private static Logger log = LoggerFactory.getLogger(DavPropertyNameSet.class);
    private final Set<DavPropertyName> set = new HashSet<DavPropertyName>();

    public DavPropertyNameSet() {
    }

    public DavPropertyNameSet(DavPropertyNameSet davPropertyNameSet) {
        this.addAll(davPropertyNameSet);
    }

    public DavPropertyNameSet(Element element) {
        if (!DomUtil.matches(element, "prop", NAMESPACE)) {
            throw new IllegalArgumentException("'DAV:prop' element expected.");
        }
        ElementIterator elementIterator = DomUtil.getChildren(element);
        while (elementIterator.hasNext()) {
            this.add(DavPropertyName.createFromXml(elementIterator.nextElement()));
        }
    }

    public boolean add(DavPropertyName davPropertyName) {
        return this.set.add(davPropertyName);
    }

    public boolean add(String string, Namespace namespace) {
        return this.set.add(DavPropertyName.create(string, namespace));
    }

    public boolean addAll(DavPropertyNameSet davPropertyNameSet) {
        return this.set.addAll(davPropertyNameSet.set);
    }

    public boolean remove(DavPropertyName davPropertyName) {
        return this.set.remove(davPropertyName);
    }

    public DavPropertyNameIterator iterator() {
        return new PropertyNameIterator();
    }

    @Override
    public boolean contains(DavPropertyName davPropertyName) {
        return this.set.contains(davPropertyName);
    }

    @Override
    public boolean addContent(PropEntry propEntry) {
        if (propEntry instanceof DavPropertyName) {
            return this.add((DavPropertyName)propEntry);
        }
        log.debug("DavPropertyName object expected. Found: " + propEntry.getClass().toString());
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int getContentSize() {
        return this.set.size();
    }

    public Collection<DavPropertyName> getContent() {
        return this.set;
    }

    private class PropertyNameIterator
    implements DavPropertyNameIterator {
        private Iterator<DavPropertyName> iter;

        private PropertyNameIterator() {
            this.iter = DavPropertyNameSet.this.set.iterator();
        }

        @Override
        public DavPropertyName nextPropertyName() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public DavPropertyName next() {
            return this.iter.next();
        }
    }
}

