/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DavPropertyName
implements DavConstants,
XmlSerializable,
PropEntry {
    private static final Map<Namespace, Map<String, DavPropertyName>> cache = new HashMap<Namespace, Map<String, DavPropertyName>>();
    public static final DavPropertyName CREATIONDATE = DavPropertyName.create("creationdate");
    public static final DavPropertyName DISPLAYNAME = DavPropertyName.create("displayname");
    public static final DavPropertyName GETCONTENTLANGUAGE = DavPropertyName.create("getcontentlanguage");
    public static final DavPropertyName GETCONTENTLENGTH = DavPropertyName.create("getcontentlength");
    public static final DavPropertyName GETCONTENTTYPE = DavPropertyName.create("getcontenttype");
    public static final DavPropertyName GETETAG = DavPropertyName.create("getetag");
    public static final DavPropertyName GETLASTMODIFIED = DavPropertyName.create("getlastmodified");
    public static final DavPropertyName LOCKDISCOVERY = DavPropertyName.create("lockdiscovery");
    public static final DavPropertyName RESOURCETYPE = DavPropertyName.create("resourcetype");
    public static final DavPropertyName SOURCE = DavPropertyName.create("source");
    public static final DavPropertyName SUPPORTEDLOCK = DavPropertyName.create("supportedlock");
    public static final DavPropertyName ISCOLLECTION = DavPropertyName.create("iscollection");
    private final String name;
    private final Namespace namespace;

    public static synchronized DavPropertyName create(String string, Namespace namespace) {
        DavPropertyName davPropertyName;
        Map<String, DavPropertyName> map = cache.get(namespace);
        if (map == null) {
            map = new HashMap<String, DavPropertyName>();
            cache.put(namespace, map);
        }
        if ((davPropertyName = map.get(string)) == null) {
            if (namespace.equals(NAMESPACE)) {
                namespace = NAMESPACE;
            }
            davPropertyName = new DavPropertyName(string, namespace);
            map.put(string, davPropertyName);
        }
        return davPropertyName;
    }

    public static synchronized DavPropertyName create(String string) {
        return DavPropertyName.create(string, NAMESPACE);
    }

    public static synchronized DavPropertyName createFromXml(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Cannot build DavPropertyName from a 'null' element.");
        }
        String string = element.getNamespaceURI();
        if (string == null) {
            return DavPropertyName.create(element.getLocalName(), Namespace.EMPTY_NAMESPACE);
        }
        return DavPropertyName.create(element.getLocalName(), Namespace.getNamespace(element.getPrefix(), string));
    }

    private DavPropertyName(String string, Namespace namespace) {
        if (string == null || namespace == null) {
            throw new IllegalArgumentException("Name and namespace must not be 'null' for a DavPropertyName.");
        }
        this.name = string;
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return (this.name.hashCode() + this.namespace.hashCode()) % Integer.MAX_VALUE;
    }

    public boolean equals(Object object) {
        if (object instanceof DavPropertyName) {
            DavPropertyName davPropertyName = (DavPropertyName)object;
            return this.name.equals(davPropertyName.name) && this.namespace.equals(davPropertyName.namespace);
        }
        return false;
    }

    public String toString() {
        return DomUtil.getExpandedName(this.name, this.namespace);
    }

    @Override
    public Element toXml(Document document) {
        return DomUtil.createElement(document, this.name, this.namespace);
    }
}

