/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Collection;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDavProperty<T>
implements DavProperty<T> {
    private static Logger log = LoggerFactory.getLogger(AbstractDavProperty.class);
    private final DavPropertyName name;
    private final boolean isInvisibleInAllprop;

    public AbstractDavProperty(DavPropertyName davPropertyName, boolean bl) {
        this.name = davPropertyName;
        this.isInvisibleInAllprop = bl;
    }

    public int hashCode() {
        int n = this.getName().hashCode();
        if (this.getValue() != null) {
            n += this.getValue().hashCode();
        }
        return n % Integer.MAX_VALUE;
    }

    public boolean equals(Object object) {
        if (object instanceof DavProperty) {
            boolean bl;
            DavProperty davProperty = (DavProperty)object;
            boolean bl2 = this.getName().equals(davProperty.getName());
            boolean bl3 = this.getValue() == null ? davProperty.getValue() == null : (bl = this.getValue().equals(davProperty.getValue()));
            return bl2 && bl;
        }
        return false;
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.getName().toXml(document);
        Object t = this.getValue();
        if (t != null) {
            if (t instanceof XmlSerializable) {
                element.appendChild(((XmlSerializable)t).toXml(document));
            } else if (t instanceof Node) {
                Node node = document.importNode((Node)t, true);
                element.appendChild(node);
            } else if (t instanceof Node[]) {
                int n = 0;
                while (n < ((Node[])t).length) {
                    Node node = document.importNode(((Node[])t)[n], true);
                    element.appendChild(node);
                    ++n;
                }
            } else if (t instanceof Collection) {
                for (Object e : (Collection)t) {
                    if (e instanceof XmlSerializable) {
                        element.appendChild(((XmlSerializable)e).toXml(document));
                        continue;
                    }
                    if (e instanceof Node) {
                        Node node = document.importNode((Node)e, true);
                        element.appendChild(node);
                        continue;
                    }
                    DomUtil.setText(element, e.toString());
                }
            } else {
                DomUtil.setText(element, t.toString());
            }
        }
        return element;
    }

    @Override
    public DavPropertyName getName() {
        return this.name;
    }

    @Override
    public boolean isInvisibleInAllprop() {
        return this.isInvisibleInAllprop;
    }
}

