/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Type
implements XmlSerializable {
    private static Map<String, Type> types = new HashMap<String, Type>();
    public static final Type WRITE = Type.create("write", DavConstants.NAMESPACE);
    private final String localName;
    private final Namespace namespace;
    private int hashCode = -1;

    private Type(String string, Namespace namespace) {
        this.localName = string;
        this.namespace = namespace;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, "locktype", DavConstants.NAMESPACE);
        DomUtil.addChildElement(element, this.localName, this.namespace);
        return element;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("LockType : {").append(this.namespace).append("}").append(this.localName);
            this.hashCode = stringBuilder.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.localName.equals(type.localName) && this.namespace.equals(type.namespace);
        }
        return false;
    }

    public static Type createFromXml(Element element) {
        if (element != null && "locktype".equals(element.getLocalName())) {
            element = DomUtil.getFirstChildElement(element);
        }
        if (element == null) {
            throw new IllegalArgumentException("'null' is not valid lock type entry.");
        }
        Namespace namespace = Namespace.getNamespace(element.getPrefix(), element.getNamespaceURI());
        return Type.create(element.getLocalName(), namespace);
    }

    public static Type create(String string, Namespace namespace) {
        String string2 = DomUtil.getExpandedName(string, namespace);
        if (types.containsKey(string2)) {
            return types.get(string2);
        }
        Type type = new Type(string, namespace);
        types.put(string2, type);
        return type;
    }
}

