/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Scope
implements XmlSerializable {
    private static final Map<String, Scope> scopes = new HashMap<String, Scope>();
    public static final Scope EXCLUSIVE = Scope.create("exclusive", DavConstants.NAMESPACE);
    public static final Scope SHARED = Scope.create("shared", DavConstants.NAMESPACE);
    private final String localName;
    private final Namespace namespace;

    private Scope(String string, Namespace namespace) {
        this.localName = string;
        this.namespace = namespace;
    }

    @Override
    public Element toXml(Document document) {
        Element element = DomUtil.createElement(document, "lockscope", DavConstants.NAMESPACE);
        DomUtil.addChildElement(element, this.localName, this.namespace);
        return element;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Scope) {
            Scope scope = (Scope)object;
            return this.localName.equals(scope.localName) && this.namespace.equals(scope.namespace);
        }
        return false;
    }

    public static Scope createFromXml(Element element) {
        if (element != null && "lockscope".equals(element.getLocalName())) {
            element = DomUtil.getFirstChildElement(element);
        }
        if (element == null) {
            throw new IllegalArgumentException("'null' is not a valid lock scope entry.");
        }
        Namespace namespace = Namespace.getNamespace(element.getPrefix(), element.getNamespaceURI());
        return Scope.create(element.getLocalName(), namespace);
    }

    public static Scope create(String string, Namespace namespace) {
        String string2 = DomUtil.getExpandedName(string, namespace);
        if (scopes.containsKey(string2)) {
            return scopes.get(string2);
        }
        Scope scope = new Scope(string, namespace);
        scopes.put(string2, scope);
        return scope;
    }
}

