/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockInfo
implements DavConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(LockInfo.class);
    private Type type;
    private Scope scope;
    private String owner;
    private boolean isDeep;
    private long timeout;
    private boolean isRefreshLock;

    public LockInfo(long l) {
        this.timeout = l > 0L ? l : Integer.MAX_VALUE;
        this.isRefreshLock = true;
    }

    public LockInfo(Scope scope, Type type, String string, long l, boolean bl) {
        this.timeout = l > 0L ? l : Integer.MAX_VALUE;
        this.isDeep = bl;
        if (scope == null || type == null) {
            this.isRefreshLock = true;
        } else {
            this.scope = scope;
            this.type = type;
            this.owner = string;
        }
    }

    public LockInfo(Element element, long l, boolean bl) throws DavException {
        this.timeout = l > 0L ? l : Integer.MAX_VALUE;
        this.isDeep = bl;
        if (element != null) {
            if (!DomUtil.matches(element, "lockinfo", NAMESPACE)) {
                log.warn("'DAV:lockinfo' element expected.");
                throw new DavException(400);
            }
            ElementIterator elementIterator = DomUtil.getChildren(element);
            while (elementIterator.hasNext()) {
                Element element2 = elementIterator.nextElement();
                String string = element2.getLocalName();
                if ("locktype".equals(string)) {
                    this.type = Type.createFromXml(element2);
                    continue;
                }
                if ("lockscope".equals(string)) {
                    this.scope = Scope.createFromXml(element2);
                    continue;
                }
                if (!"owner".equals(string)) continue;
                this.owner = DomUtil.getChildTextTrim(element2, "href", NAMESPACE);
                if (this.owner != null) continue;
                this.owner = DomUtil.getTextTrim(element2);
            }
            this.isRefreshLock = false;
        } else {
            this.isRefreshLock = true;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isRefreshLock() {
        return this.isRefreshLock;
    }

    @Override
    public Element toXml(Document document) {
        if (this.isRefreshLock) {
            return null;
        }
        Element element = DomUtil.createElement(document, "lockinfo", NAMESPACE);
        element.appendChild(this.scope.toXml(document));
        element.appendChild(this.type.toXml(document));
        if (this.owner != null) {
            DomUtil.addChildElement(element, "owner", NAMESPACE, this.owner);
        }
        return element;
    }
}

