/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.header.TimeoutHeader;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockDiscovery
extends AbstractDavProperty<List<ActiveLock>> {
    private List<ActiveLock> activeLocks = new ArrayList<ActiveLock>();

    public LockDiscovery() {
        super(DavPropertyName.LOCKDISCOVERY, false);
    }

    public LockDiscovery(ActiveLock activeLock) {
        super(DavPropertyName.LOCKDISCOVERY, false);
        this.addActiveLock(activeLock);
    }

    public LockDiscovery(ActiveLock[] activeLockArray) {
        super(DavPropertyName.LOCKDISCOVERY, false);
        ActiveLock[] activeLockArray2 = activeLockArray;
        int n = activeLockArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActiveLock activeLock = activeLockArray2[n2];
            this.addActiveLock(activeLock);
            ++n2;
        }
    }

    private void addActiveLock(ActiveLock activeLock) {
        if (activeLock != null) {
            this.activeLocks.add(activeLock);
        }
    }

    @Override
    public List<ActiveLock> getValue() {
        return this.activeLocks;
    }

    @Override
    public Element toXml(Document document) {
        Element element = this.getName().toXml(document);
        for (ActiveLock activeLock : this.activeLocks) {
            element.appendChild(activeLock.toXml(document));
        }
        return element;
    }

    public static LockDiscovery createFromXml(Element element) {
        if (!DomUtil.matches(element, "lockdiscovery", NAMESPACE)) {
            throw new IllegalArgumentException("DAV:lockdiscovery element expected.");
        }
        ArrayList<ALockImpl> arrayList = new ArrayList<ALockImpl>();
        ElementIterator elementIterator = DomUtil.getChildren(element, "activelock", NAMESPACE);
        while (elementIterator.hasNext()) {
            Element element2 = elementIterator.nextElement();
            arrayList.add(new ALockImpl(element2));
        }
        return new LockDiscovery(arrayList.toArray(new ActiveLock[arrayList.size()]));
    }

    private static class ALockImpl
    implements ActiveLock {
        private final Element alElement;

        private ALockImpl(Element element) {
            if (!DomUtil.matches(element, "activelock", NAMESPACE)) {
                throw new IllegalArgumentException("DAV:activelock element expected.");
            }
            this.alElement = element;
        }

        @Override
        public boolean isLockedByToken(String string) {
            String string2 = this.getToken();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }

        @Override
        public boolean isExpired() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public String getToken() {
            Element element = DomUtil.getChildElement(this.alElement, "locktoken", NAMESPACE);
            if (element != null) {
                return DomUtil.getChildText(element, "href", NAMESPACE);
            }
            return null;
        }

        @Override
        public String getOwner() {
            String string = null;
            Element element = DomUtil.getChildElement(this.alElement, "owner", NAMESPACE);
            if (element != null) {
                string = DomUtil.hasChildElement(element, "href", NAMESPACE) ? DomUtil.getChildTextTrim(element, "href", NAMESPACE) : DomUtil.getTextTrim(element);
            }
            return string;
        }

        @Override
        public void setOwner(String string) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public long getTimeout() {
            String string = DomUtil.getChildTextTrim(this.alElement, "timeout", NAMESPACE);
            return TimeoutHeader.parse(string, Integer.MIN_VALUE);
        }

        @Override
        public void setTimeout(long l) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean isDeep() {
            String string = DomUtil.getChildTextTrim(this.alElement, "depth", NAMESPACE);
            return "infinity".equalsIgnoreCase(string);
        }

        @Override
        public void setIsDeep(boolean bl) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public String getLockroot() {
            Element element = DomUtil.getChildElement(this.alElement, "lockroot", NAMESPACE);
            if (element != null) {
                return DomUtil.getChildTextTrim(element, "href", NAMESPACE);
            }
            return null;
        }

        @Override
        public void setLockroot(String string) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public Type getType() {
            return Type.createFromXml(DomUtil.getChildElement(this.alElement, "locktype", NAMESPACE));
        }

        @Override
        public Scope getScope() {
            return Scope.createFromXml(DomUtil.getChildElement(this.alElement, "lockscope", NAMESPACE));
        }

        @Override
        public Element toXml(Document document) {
            return (Element)document.importNode(this.alElement, true);
        }
    }
}

