/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutHeader
implements Header,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(TimeoutHeader.class);
    private final long timeout;

    public TimeoutHeader(long l) {
        this.timeout = l;
    }

    @Override
    public String getHeaderName() {
        return "Timeout";
    }

    @Override
    public String getHeaderValue() {
        if (this.timeout == Integer.MAX_VALUE) {
            return "Infinite";
        }
        return "Second-" + this.timeout / 1000L;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static TimeoutHeader parse(HttpServletRequest httpServletRequest, long l) {
        String string = httpServletRequest.getHeader("Timeout");
        long l2 = TimeoutHeader.parse(string, l);
        return new TimeoutHeader(l2);
    }

    public static long parse(String string, long l) {
        long l2 = l;
        if (string != null && string.length() > 0) {
            int n = string.indexOf("Second-");
            if (n >= 0) {
                int n2 = n += 7;
                while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                    ++n2;
                }
                try {
                    l2 = 1000L * Long.parseLong(string.substring(n, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("Invalid timeout format: " + string);
                }
            } else if (string.equalsIgnoreCase("Infinite")) {
                l2 = Integer.MAX_VALUE;
            }
        }
        return l2;
    }
}

