/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthHeader
implements Header,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(DepthHeader.class);
    private final int depth;

    public DepthHeader(int n) {
        if (n != 0 && n != 1 && n != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid depth: " + n);
        }
        this.depth = n;
    }

    public DepthHeader(boolean bl) {
        this.depth = bl ? Integer.MAX_VALUE : 0;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getHeaderName() {
        return "Depth";
    }

    @Override
    public String getHeaderValue() {
        if (this.depth == 0 || this.depth == 1) {
            return String.valueOf(this.depth);
        }
        return "infinity";
    }

    public static DepthHeader parse(HttpServletRequest httpServletRequest, int n) {
        String string = httpServletRequest.getHeader("Depth");
        if (string == null || "".equals(string)) {
            return new DepthHeader(n);
        }
        return new DepthHeader(DepthHeader.depthToInt(string));
    }

    private static int depthToInt(String string) {
        int n;
        if (string.equalsIgnoreCase("infinity")) {
            n = Integer.MAX_VALUE;
        } else if (string.equals("0")) {
            n = 0;
        } else if (string.equals("1")) {
            n = 1;
        } else {
            throw new IllegalArgumentException("Invalid depth value: " + string);
        }
        return n;
    }
}

